/* 

NoTippingApplet

 version 1.0

 Tyler Neylon, 2002

version 2.0 by:
Alex Halter, Azam Asl, Michal Novemsky, 2011
*/


import java.applet.*;
//import java.lang.*; //not used here
import java.awt.*;
import java.awt.event.*;

/**
 *
 * @author HalterA,AAsl,MNovemsky
 * The main class for the applet
 */

public class NoTippingApplet
        extends Applet {

  
   // Data members ntf, winner, and score were added for the Dr Ecco website
   
   public static NoTippingFrame ntf;
   public static String winner = "not set";
   public static String score = "not set";
   /**
    * Method getWinner was added for the Dr Ecco website
    */
   public String getWinner()
   {
	   return winner;
   }
   /**
    * Method getScore was added for the Dr Ecco website
    */
   public String getScore()
   {
	   return score;
   }

   
    public void init() {
    }

    /**
     * Used instead of main if No Tipping is run as an applet rather than an application
     */
	public void start() {
		//System.out.println("hi, I'm in applet.start()");
		ntf = new NoTippingFrame(); //added for Dr Ecco site
		//System.out.println("i just declared a new no tipping frame");
		//System.out.println("hello" + ntf.main_display.game_over);
		
		//this while loop must be here;
		//without it the wrong winner may be displayed
		while(!ntf.main_display.game_over) 
		{
			try{
				Thread.sleep(100);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		
		//set winner and score here
	       if(ntf.main_display.game_over)
	        {
	        int winnerInt = ntf.main_display.who_won;
	        if(winnerInt == 0)
	        	winner = "Red";
	        else if(winnerInt == 1)
	        	winner = "Blue";
	        else if(winnerInt == 2)
	        	winner = "Green";
	        else if(winnerInt == 3)
	        	winner = "Cyan";
	        score = "won";
	        //System.out.println("finished the game in start! winner is " + winner + " and score is " + score);
	        }//if
	       
	       else
	    	 System.out.println("in start, game did not end");
	}
	
	/**
	 * Main is used for running No Tipping as a standalone application
	 * @param args
	 */
    public static void main(String[] args) {
    	final Applet applet = new NoTippingApplet();
        System.runFinalizersOnExit(true);
        Frame frame = new Frame ("MyApplet");
        frame.addWindowListener (new WindowAdapter() {
            public void windowClosing (WindowEvent event) {
                applet.stop();
                applet.destroy();
                System.exit(0);
            }
        });
        frame.add ("Center", applet);
        NoTippingAppletStub noTippingAppletStub = new NoTippingAppletStub(args, applet);
        //Player.setProperties(noTippingAppletStub); //only uncomment if using Prasad Tadimalla's Player class
        applet.setStub (noTippingAppletStub);
        frame.show();
        applet.init();
        applet.start();
        frame.pack();
        
    }
}
/**
 * 
 * @author HalterA,AAsl,MNovemsky
 * class that sets up the window in which the game is played
 */
class NoTippingFrame extends Frame {
	public NoTippingComponent main_display;
	public NoTippingFrame() {
		setLayout(new BorderLayout());
		/*NoTippingComponent*/ main_display = new NoTippingComponent();
		add(main_display, "Center");
		Container toolbar = new Panel();
		GridBagLayout gbl = new GridBagLayout();
		GridBagConstraints gbc = new GridBagConstraints();
		toolbar.setLayout(gbl);
		gbc.fill = GridBagConstraints.BOTH;
		gbc.weightx = 1.0;
		String[] numPlayers = {"2","3","4"};
		Label tf = new Label("Num Players",Label.CENTER);
		String[] numWeights = {"2","3","4","5","6","7","8","9","10","11","12","13","14","15"};
		Label wLab = new Label("Num Weights",Label.CENTER);

		gbl.setConstraints(tf, gbc);
		toolbar.add(tf);

       addChoice("Num Players", numPlayers, main_display, gbl, gbc, toolbar);
		gbl.setConstraints(wLab, gbc);
		toolbar.add(wLab);

       addChoice("Num Weights", numWeights, main_display, gbl, gbc, toolbar);
       
       
        addButton("Restart", main_display, gbl, gbc, toolbar);


		addWindowListener(new WindowCloser());

		add(toolbar, "North");
		setTitle("The No Tipping Game");
		pack();
		setVisible(true);
		setEnabled(true);
	}
/**
 * For adding a button to the toolbar.
 * @param name
 * @param main_display
 * @param gbl
 * @param gbc
 * @param toolbar
 */
    private void addButton(String name, NoTippingComponent main_display, GridBagLayout gbl, GridBagConstraints gbc, Container toolbar) {
        Button b = new Button(name);
        b.setActionCommand(name);
        b.addActionListener(main_display);
        gbl.setConstraints(b, gbc);
        toolbar.add(b);
    }
/**
 * For adding a menu to the toolbar.
 * @param name
 * @param choices
 * @param main_display
 * @param gbl
 * @param gbc
 * @param toolbar
 */
    private void addChoice(String name, String[] choices, NoTippingComponent main_display, GridBagLayout gbl, GridBagConstraints gbc, Container toolbar) {
        Choice c = new Choice();
        for (int i=0; i<choices.length; i++)
            c.addItem(choices[i]);
        c.setName(name);
        c.addItemListener(main_display);
        gbl.setConstraints(c, gbc);
        if(name == "Num Weights")
        	c.select("10"); //initializes the menu to the default number of weights, 10
        toolbar.add(c);
    }
}
/**
 * 
 * @author HalterA,AAsl,MNovemsky
 * class that cleans up after the game window is closed
 */
class WindowCloser extends WindowAdapter {
	public void windowClosing(WindowEvent e) {
		System.out.println("windowClosing(WindowEvent)");
		e.getWindow().dispose();
	}
}

