/**
 * Player abstract class
 */
public abstract class Player {
  protected long        time = 0;
  protected final long  timeLimit;
  protected String      name = "";
  protected int         id;
  protected int         type;
  
   public Player(long timeLimit, int id, int type) {
      this.timeLimit = timeLimit;
      this.id        = id;
      this.type      = type;
   }

   public String getName() {
      if(type == Const.SNATCHER) {
         return new String("Snatcher - " + name);
      }
      else {
         return new String("Jumper - " + name);
      }      
   }

   public int getId() {
      return id;
   }

   public int getType() {
      return type;
   }

   protected void addTime(long time) {
      this.time += time;
   }

   public long getTime() {
      return time;
   }

   public void resetTime() {
      time = 0;
   }

   public boolean isOverTime() {
      return time > timeLimit;
   }

   /**
    * This function must be overridden.
    */
   public abstract MoveList play(Board board);

}
