//*****************************
//  VLine.Java

//  A Point Class developed
//  by Monty Faidley and
//  Chris Poultney
//  December 2, 1996
//*****************************

public class VLine {
  public double A,B,C;

  VLine() {
    A=0;
    B=0;
    C=0;
  }

  VLine(VPoint q1,VPoint q2) {
    this();
    Set(q1,q2);
  }

  VLine(double a,double b,double c) {                
    this();
    A=a;
    B=b;
    C=c;
  }

  public void Set(VPoint q1,VPoint q2) {
    double q1x=q1.dX();
    double q1y=q1.dY();
    double q2x=q2.dX();
    double q2y=q2.dY();
    double s;
    A=-(q2y-q1y);
    B=(q2x-q1x);
    C=-A*q1x-B*q1y;
    s=Math.abs(A)>Math.abs(B) ? A : B;

    if(s!=0) {
      A/=s;
      B/=s;
      C/=s;
    }

  }

  public double Dist(VPoint q) {
    double d=A*A+B*B+C*C;
    return Eval(q)/Math.sqrt(d);
  }

  public double Dist2(VPoint q) {
    double d=A*A+B*B+C*C;
    double e=Eval(q);
    return e*e/d;
  }

  public double Eval(VPoint q) {
    double v=A*q.dX()+B*q.dY()+C;
    return v;
  }

  public VPoint Intersect(VLine l) {
    VPoint q=null;
    double x,y;
    double temp,tempy;

    temp=A*l.B-B*l.A;
    if(temp!=0) {
      tempy=(C*l.A-A*l.C)/temp;
      if(A!=0) {
        x=((-B*tempy-C)/A);
      } else {
        x=((-l.B*tempy-l.C)/l.A);
      }
      y=tempy;
      q=new VPoint(x,y);
    } else if(C==l.C) {
      // x and y=INF
    } else {
      q=null;
    }

    return q;
  }
}
