//*****************************
//  VBTree.Java
//  A tree/list class developed
//  by Monty Faidley and
//  Chris Poultney
//  December 2, 1996
//*****************************

public class VBTree {
  static VBTree[] nodes;
  static VLine[] bisect;
  static int numPts;
  static int maxPts=0;
  static VBTree root=null,head=null;
  static VBTree currentf=null,currentb=null;
  static VPoint center;
  VPoint point;
  int num;
  double theta;
  VBTree left=null,right=null,prev=null,next=null;

  public void Reset() {
    for(int i=0;i<numPts;i++) {
      nodes[i]=null;
    }
    numPts=0;
    root=null;
    head=null;
    currentf=null;
    currentb=null;
  }

  public VBTree(int p) {
    nodes=new VBTree[p];
    bisect=new VLine[p+3];
    maxPts=p;
    numPts=0;
  }

  public VBTree(VPoint p) {
    point=new VPoint(p);
    num=numPts;
  }

  public void Add(VPoint p) {
    if(numPts==0) {
      nodes[numPts++]=this;
      point=new VPoint(p);
      num=0;
    } else {
      nodes[numPts]=new VBTree(p);
      numPts++;
    }
  }

  public int numPts() {
    return numPts;
  }

  public int num() {
    return num;
  }

  public VPoint point(int p) {
    return nodes[p].point;
  }

  public VLine bisect(int p) {
    return bisect[p];
  }

  public void FindBisectors(VLine[] border,VPoint here,int pts) {
    VSegment tempSeg=new VSegment();
    for(int i=0;i<4;i++) {
      bisect[i]=border[i];
    }

    for(int i=4;i<pts+3;i++) {
      tempSeg.Set(point(i-4),here);
      bisect[i]=tempSeg.PB();
    }
  }

  public void Sort(VPoint p,int tempPts) {
    VBTree tempPrev;
    center=p;
    for(int i=0;i<numPts;i++) {
      nodes[i].theta=nodes[i].point.Theta(p);
      nodes[i].left=null;
      nodes[i].right=null;
      nodes[i].prev=null;
      nodes[i].next=null;
    }

    for(int i=0;i<tempPts;i++) {
      if(i==0) {
        root=nodes[i];
        head=nodes[i];
        nodes[i].next=nodes[i];
        nodes[i].prev=nodes[i];
      } else {
        tempPrev=TreeInsert(root,nodes[i]);
     
        if(tempPrev==null) {
          tempPrev=head.prev;
          if(nodes[i].theta<head.theta) {
            head=nodes[i];
          }
        }
        nodes[i].next=tempPrev.next;
        nodes[i].prev=tempPrev;
        tempPrev.next=nodes[i];
        nodes[i].next.prev=nodes[i];
      }
    }
  }

  VBTree TreeInsert(VBTree curr,VBTree addMe) {
    VBTree temp=null;
    if(addMe.theta<=curr.theta) {
      if(curr.left!=null) {
        temp=TreeInsert(curr.left,addMe);
      } else {
        curr.left=addMe;
        temp=null;
      }
    } else {
      if(curr.right!=null) {
        temp=TreeInsert(curr.right,addMe);
      } else {
        curr.right=addMe;
        temp=null;
      }
    }

    if(temp==null) {
      if(curr.theta<addMe.theta) {
        return curr;
      } else {
        return null;
      }
    } else {
      if (curr.theta>temp.theta && curr.theta<addMe.theta) {
        return curr;
      } else {
        return temp;
      }
    }
  }

  public VBTree SetPrevNext(VPoint p) {
    double tempTheta=p.Theta(center);

    if(root==null) {
      currentf=null;
      currentb=null;
    } else {
      currentb=FindClosestUnder(root,tempTheta);
      if(currentb==null) {
        currentf=head;
        currentb=currentf.prev;
      } else {
        currentf=currentb.next;
      }
    }
    return currentf;
  }

  public VBTree GetNext() {
    currentf=currentf.next;
    return currentf.prev;
  }

  public VBTree GetPrev() {
    currentb=currentb.prev;
    return currentb.next;
  }

  public boolean IterDone() {
    return (currentf==currentb);
  }

  public VBTree FindClosestUnder(VBTree curr,double myTheta) {
    if(curr==null) {
      return null;
    } else if(curr.theta<myTheta) {
      if(curr.next.theta>=myTheta) {
        return curr;
      } else {
        return(FindClosestUnder(curr.right,myTheta));
      }
    } else {
      return(FindClosestUnder(curr.left,myTheta));
    }
  }

  protected void recPrint(VBTree curr) {
    if(curr!=null) {
      if(curr.left!=null) {
        recPrint(curr.left);
      }
      System.out.println("("+curr.point.dX()+","+curr.point.dY()+")"+","+curr.theta);
      if(curr.right!=null) {
        recPrint(curr.right);
      }
    }
  }

  protected void listPrintBack(VBTree head) {
    VBTree curr=head;
    if(curr!=null) {
      System.out.println(curr.num+":("+curr.point.dX()+","+curr.point.dY()+")"+","+curr.theta);
      curr=curr.prev;
      while(curr!=head) {
        System.out.println(curr.num+":("+curr.point.dX()+","+curr.point.dY()+")"+","+curr.theta);
        curr=curr.prev;
      }
    }
  }

  protected void listPrint(VBTree head) {
    VBTree curr=head;
    if(curr!=null) {
      System.out.println(curr.num+":("+curr.point.dX()+","+curr.point.dY()+")"+","+curr.theta);
      curr=curr.next;
      while(curr!=head) {
        System.out.println(curr.num+":("+curr.point.dX()+","+curr.point.dY()+")"+","+curr.theta);
        curr=curr.next;
      }
    }
  }
}
