var kMAX_TAGS = 10;
var kIMAGE_SIZE = 3;


function getCurrentTime() {
    clk = new Date();
    return clk.getTime();
}


/**
* Populate the Artist Deck (Gallery) 
* @param name	last.fm artist name
* @param mbid 	music brainz id
* @return      
*/
function Artist(name,mbid) {
	var _this = this;
    this.tagCount = 0;                  // Number of tags
    this.name = name;                   // Name of the Artist
    this.mbid = mbid;
    this.imageURL = "";
    this.tagList = new Array();         // Tag list (Objects: name, count, url)
    this.tagDict = {};
    this.fitnessScore = 0.0;            // Fitness Score for the given artist
    this.tagsReady = false;             // Boolean to know if we have loaded the tags info
    this.hoverBox = "";
    this.MAX_TAGS = kMAX_TAGS;          // Max tags to display (constant)
    this.SUPPRESS = true;
    
    /**
    * Sets the fitness score
    * @param score   Float from 0-1 representing the fitness score
    * @return         
    */
    this.setFitnessScore = function( score ) {
        this.fitnessScore = score;
    }
    
    
    /**
    * Sets the artist image URL
    * @param imageURL	last.fm artist image URL
    * @return         
    */
    this.setImageURL = function( imageURL) {
        this.imageURL = imageURL;
    }
    
    
    /**
    * Given a target list of tags, compute the scalar match.
	* 	Stores the result in this.fitnessScore 
    * @param targetTagList	array of last.fm tag objects
    * @return         
    */
    this.computeFitnessScore = function( targetTagList ){
    	score = 0.0;
    	totalSum = 0.0;
    	for (var n=0;n<this.MAX_TAGS;n++){
    		tag = targetTagList[n];
    		totalSum += Number(tag.count);
    		if ( _this.tagDict.hasOwnProperty(tag.name) ){
    			score += Math.min( _this.tagDict[tag.name], Number(tag.count) );
    		}
    	}
    	_this.setFitnessScore(score / totalSum);

        return score / totalSum;
    }

    /**
    * Properly caches last.fm tags corresponding to this artist object
    * @param tags   Array of tags objects (tag object: name, count, url)
    * @return         
    */
    this.cacheTags = function( tags ) {
    	_this.tagCount = tags.length;
        for (i = 0; i < _this.tagCount; i++ ) {
            _this.tagList[i] = tags[i]
            _this.tagDict[tags[i].name] = Number(tags[i].count);
        }
        // console.log(_this.name + " responded in " + (getCurrentTime()-this.callTime)/1000.0 + " seconds." );
    }

    /**
    * Callback function for the artist info from LastFM
    * @param data   data from LastFM getArtistInfo
    * @return
    */
    this.tagsCallback = function( data ) {
        _this.cacheTags( data.toptags.tag );
        _this.tagsReady = true;
        if(!_this.SUPPRESS) {
        	this.printTags();
        }
        
    }

	this.setHoverBox = function( hoverInfo ) {
		this.hoverBox = hoverInfo;
	}

    /**
    * Retrieves the Top Tags from LastFM and calls the tagsCallback
    * @param
    * @return         
    */

    this.getTopTags = function( ) {
        this.callTime = getCurrentTime();
        lastfm.artist.getTopTags({mbid: _this.mbid},
            {
                success: function(data){
                    _this.tagsCallback( data );
                }, 
                    error: function(code, message){
                    alert(this.name + " failed retrieving tags!");
                }
            }
        );
    }

    
    /**
    * Prints the Artist Object
    * @param
    * @return       HTML formatted string
    */
    this.print = function( score ) {
        if ( _this.tagsReady ) {
        	score = ((this.fitnessScore*100).toFixed(2));
        	string = '<li><a href="#"><img src=\"' + this.imageURL + '\" class="queryArtist"/><span>'
        	+ this.name + ' : ' + score + '</span></a></li>';
            return string;
        }
    };
    
    this.printTags = function( ) {
        if ( _this.tagsReady) {
            var tags = "";
            for ( var i = 0; i < this.MAX_TAGS; i++ ) {
                if ( i % 2 == 0) {
                	tags += '<tr class="tagRow">'
                }
                tags += '<td class="tagName">' + _this.tagList[i].name + '</td>' + 
                    '<td class="tagBar" id="tagBar' + i + '">[ Loading Progress Bar ]</td>';
                if ( (i+1) % 2 == 0) {
                	tags += "</tr>";
                }
            }
            string = '<br/><table align="center"><tr><td><img src=\"' + this.imageURL + '\" class="hoverArtist" /></td></tr>'
             		+ '<tr><td>' + this.name + '</td></tr></table><br/>'
                	+ '<table id="tagsQA">' + tags + '</table>';
            
            this.hoverBox.html( string );

            var progressBars = new Array( );
            for ( var i = 0; i < this.MAX_TAGS; i++ ) {
                progressBars[i] = new JS_BRAMUS.jsProgressBar($('tagBar'+i), this.tagList[i].count,
                    {
                        barImage	: Array(
                            'images/bramus/percentImage_back4.png',
                            'images/bramus/percentImage_back3.png',
                            'images/bramus/percentImage_back2.png',
                            'images/bramus/percentImage_back1.png'
                        ),
                        onTick : function(pbObj) {return true;}
                    }
                );

            }
        }
    };
	
}


function ArtistDeck( max_num_artists ) {
    this.tagDict = {};                	// tag dictionary
    this.mbidDict = {};					// mbid dictionary
    this.MAX_TOP_ARTISTS = max_num_artists;
    this.hiddenIndex = Math.floor(Math.random()*this.MAX_TOP_ARTISTS);              // index of target artist
    this.artists = new Array(this.MAX_TOP_ARTISTS);
    this.pastGuesses = {};
    this.callTime = 0;
    this.isReady = false;
    
    /**
    * Callback function for the artist info from LastFM
    * @param data   data from LastFM getArtistInfo
    * @return
    */
    this.topArtistsCallback = function( data ) {
    	artistArray = data.artists.artist;
    	N = artistArray.length;
    	console.log(artistArray);
        for (n=0;n<N;n++){
        	console.log(n + " : " + artistArray[n].name);
        	this.artists[n] = new Artist(artistArray[n].name, artistArray[n].mbid);
            this.artists[n].setImageURL(artistArray[n].image[kIMAGE_SIZE]["#text"]);
            this.mbidDict[artistArray[n].mbid] = n;
        }
        console.log("Retrieved " + N + " Artists in " + (getCurrentTime()-this.callTime)/1000.0 + " seconds." );
        this.targetArtist = this.artists[this.hiddenIndex];
        
        // TODO: REMOVE ME!!!
        console.log(this.targetArtist.name)
        // this.targetArtist.getTopTags(); 
        this.isReady = true;
    }

    /**
    * Retrieves the Artist Info from LastFM and calls the artistCallback
    * @param
    * @return         
    */
    this.getTopArtists = function( ) {
        artistDeck = this;
        this.callTime = getCurrentTime();
        lastfm.chart.getTopArtists({limit: this.MAX_TOP_ARTISTS},{},
            {
                success: function(data){
                    /* Use data. */
                    artistDeck.topArtistsCallback( data );
                }, 
                error: function(code, message){
                    /* Show error message. */
                    alert("ArtistDeck.getTopArtists() failed!");
                }
            }
        );
    }

    /**
    * Retrieves the Top Tags from LastFM and calls the tagsCallback
    * @param
    * @return         
    */
    this.getTopArtistTags = function( ) {
    	artistDeck = this; 
        N = artistDeck.artists.length;
    	this.callTime = getCurrentTime();
        for (n=0;n<N;n++){
        	artist = artistDeck.artists[n];
        	console.log(n + " : " + artist.name);
        	artist.getTopTags();
        	
        }
        
        // console.log("Retrieved " + N + " Artists in " + (getCurrentTime()-this.callTime)/1000.0 + " seconds." );
    }

}
