/*
 * Decompiled with CFR 0.152.
 */
class VPoint {
    private double x;
    private double y;

    public VPoint() {
        this.x = 0.0;
        this.y = 0.0;
    }

    public VPoint(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public VPoint(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public VPoint(VPoint vPoint) {
        this.x = vPoint.x;
        this.y = vPoint.y;
    }

    public int iX() {
        return (int)this.x;
    }

    public int iY() {
        return (int)this.y;
    }

    public double dX() {
        return this.x;
    }

    public double dY() {
        return this.y;
    }

    public double Theta(VPoint vPoint) {
        return this.Theta(vPoint.iX(), vPoint.iY());
    }

    public double Theta(int n, int n2) {
        double d = this.x - (double)n;
        double d2 = this.y - (double)n2;
        double d3 = Math.sqrt(d * d + d2 * d2);
        double d4 = d / d3;
        if (d2 >= 0.0) {
            return Math.acos(d4);
        }
        return Math.PI * 2 - Math.acos(d4);
    }

    public void Set(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public void Set(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public void Set(VPoint vPoint) {
        this.x = vPoint.x;
        this.y = vPoint.y;
    }

    public boolean equals(VPoint vPoint) {
        return this.x == vPoint.x && this.y == vPoint.y;
    }
}

