/*
 * Decompiled with CFR 0.152.
 */
package wordwrestlegame;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import wordwrestlegame.FancyCaret;
import wordwrestlegame.WordWrestleGame;
import wordwrestlegame.utils.Constants;

public class InputWordPanel
extends JPanel
implements ActionListener {
    public final String playerName;
    private static final long serialVersionUID = 1L;
    private final WordWrestleGame wwGame;
    private FancyCaret myCaret = new FancyCaret();
    private int playerScore;
    private final int playerId;
    private final Font newTextFieldFont;
    protected JTextField playerNameField;
    protected JTextField textField;
    protected JTextField scoreTag;
    protected JTextField scoreField;
    protected JTextArea textArea;

    public InputWordPanel(WordWrestleGame game, String name, int id) {
        super(new GridBagLayout());
        this.wwGame = game;
        this.playerName = name;
        this.playerId = id;
        this.playerScore = 0;
        this.playerNameField = new JTextField(this.playerName + ":", 10);
        this.playerNameField.setEditable(false);
        if (this.playerId == 1) {
            this.playerNameField.setForeground(Constants.BLUE);
        } else {
            this.playerNameField.setForeground(Constants.RED);
        }
        this.newTextFieldFont = new Font(this.playerNameField.getFont().getName(), this.playerNameField.getFont().getStyle(), 16);
        this.textField = new JTextField(15);
        this.textField.addActionListener(this);
        this.textField.setFont(this.newTextFieldFont);
        if (id != 1) {
            this.textField.setEditable(false);
            this.textField.setBackground(Color.WHITE);
        } else {
            this.textField.requestFocus();
            this.myCaret.setBlinkRate(500);
            this.textField.setCaret(this.myCaret);
            this.textField.setBackground(Color.LIGHT_GRAY);
        }
        this.scoreTag = new JTextField("Score:", 10);
        this.scoreTag.setEditable(false);
        this.scoreField = new JTextField(Integer.toString(this.playerScore), 15);
        this.scoreField.setEditable(false);
        this.textArea = new JTextArea(2, 15);
        this.textArea.setEditable(false);
        this.textArea.setFont(this.newTextFieldFont);
        JScrollPane scrollPane = new JScrollPane(this.textArea);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.fill = 2;
        c.ipady = 20;
        this.add((Component)this.playerNameField, c);
        c.gridx = 1;
        c.fill = 2;
        this.add((Component)this.textField, c);
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 2;
        this.add((Component)this.scoreTag, c);
        c.gridx = 1;
        this.add((Component)this.scoreField, c);
        c.gridy = 2;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.add((Component)scrollPane, c);
    }

    public void resetInputWordPanel() {
        this.textField.setText("");
        this.textArea.setText("");
        this.scoreField.setText("");
        this.playerScore = 0;
        if (this.playerId != 1) {
            this.setInputAreaEditable(false);
            System.out.println("reset input word panel, NOT editable");
        } else {
            this.setInputAreaEditable(true);
            System.out.println("reset input word panel, editable");
        }
    }

    public void setInputAreaEditable(boolean isEditable) {
        if (isEditable) {
            this.textField.setEditable(true);
            this.textField.requestFocus();
            this.myCaret.setBlinkRate(500);
            this.textField.setCaret(this.myCaret);
            this.textField.setBackground(Color.LIGHT_GRAY);
        } else {
            this.textField.setEditable(false);
            this.textField.setBackground(Color.WHITE);
        }
        this.textField.setText("");
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String text = this.textField.getText();
        int isValidInput = this.isValidWordInput(text);
        if (isValidInput == -1) {
            JOptionPane.showMessageDialog(this, "Not a word!", "Illegal Input Error", 0);
            return;
        }
        if (isValidInput == -2) {
            JOptionPane.showMessageDialog(this, "No Common Suffix-Prefix", "Illegal Input Error", 0);
            return;
        }
        if (isValidInput == -3) {
            JOptionPane.showMessageDialog(this, "Word Already Used", "Illegal Input Error", 0);
            return;
        }
        this.playerScore += isValidInput * isValidInput;
        this.scoreField.setText(Integer.toString(this.playerScore));
        this.textArea.append(text + "\n");
        this.textField.selectAll();
        this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
        if (this.wwGame != null) {
            this.setInputAreaEditable(false);
            this.wwGame.playerInputedWord(text, this.playerId);
        }
    }

    private int isValidWordInput(String inputWord) {
        if (!this.wwGame.getPft().isValid(inputWord)) {
            return -1;
        }
        if (this.wwGame != null) {
            if (this.wwGame.isWordInSet(inputWord)) {
                return -3;
            }
            int commonLen = this.wwGame.updateCompressedWord(inputWord);
            this.wwGame.addWordToSet(inputWord);
            if (commonLen > 0) {
                return commonLen;
            }
            return -2;
        }
        return 0;
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("Word Input Frame");
        frame.setDefaultCloseOperation(3);
        frame.add(new InputWordPanel(null, "playerName", 1));
        frame.pack();
        frame.setVisible(true);
    }

    public int getPlayerScore() {
        return this.playerScore;
    }

    public void setCaretFocus() {
        this.myCaret.setBlinkRate(500);
        this.textField.setCaret(this.myCaret);
        this.textField.requestFocus();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InputWordPanel.createAndShowGUI();
            }
        });
    }
}

