/*
The codes is revised as follows:
    In the old codes, the burst with smallest probability cand->grbprob is reported.
    In the new codes, the burst sent to this procedure is of the smallest probability,
	so need not test its value.

*/

#include "Reconstruction.h"
#include "Offline.h"
#include "grb.h"
#include "cfortran.h"
#include "hbook.h"
#include <time.h>

double pois( double, double);
double intpois( double, double);

int grb_finder_publish( int *ipublish, GRB_CANDIDATE *cand, EVENT *evbuffer,
                        PROB *prob)
{
  static double localDec,localRA,localDec2000,sidTime,time2,ha,dec,ra;
  static double minra,minha,mindec,mint0,minback,minprob=1.;
  float         xra,xdec,racorr;
  static int    minsignal,iev,i,hid=2000,miniha,minidec;
  int           inbin,nhabins,hour,minute,ra_hr,ra_mi,ra_se,local_nTail,local_nBuff;
  int           doy,month,day,year,ultra,type,crap;
  double        second,zangle;
  char          title[500],filename[300],filename2[300],command[500],rname[300];
  char          pname[300],psname[300],pcommand[500];
  char          chfield[100],str[300],tcrap[100];
  FILE          *fp,*fp2,*fph,*fpt,*fpn;
  int           nrad[50]={0},area[100],rbin,numbin,trignum;
  float         area1,area2,area3,min_rate;
  time_t        myt;
  int           hour2, day2,month2,year2,min2,sec2,nmesg=0,hh;
  char          atime[100],dir[300],pubdir[300],mname[300],cdir[300];
  int			duration_print, iha_print, idec_print;
  
  iha_print=cand->iha;
  idec_print=cand->idec;
  duration_print=cand->idur;
  /* ipublish = 0 : nothing special about the call            */
  /* ipublish = 1 : first call, add a \n to make new line     */
  /* ipublish = 2 : called after search to report best result */

  if(ON){ 
    sprintf(dir,"/home/daq/grb/log/");
    sprintf(cdir,"/home/daq/grb/code/");
    sprintf(pubdir,"/home/daq/public_html/grb/");
  }
  else{
    sprintf(dir,"./");
    sprintf(pubdir,"./pub/grb/");
    sprintf(cdir,"./");
  }
  
  //if (*ipublish==1) {
    sprintf(str,"\n");
    grb_finder_logger(str);
    //*ipublish = 0;
    minprob   = 1.;
  //}
   
  //if (*ipublish ==0) { 

    /* calcualte siderial time */
    time2 = cand->t0+cand->duration/2.;
    Angle2Astro(cand->julDate, time2, 90. , 0., &localDec, &localRA);
    J2000(cand->julDate,localDec,localRA,&localDec2000,&sidTime);
    ha = BINSIZE*(cand->iha)-180.;
    dec= BINSIZE*(cand->idec)-60.;
    ra = sidTime+ha;
    if (ra<0.)   ra+=360.;
    if (ra>360.) ra-=360.;

    if (cand->grbprob<minprob) {
      minprob = cand->grbprob;
      minra   = ra;
      mindec  = dec;
      minha   = ha;
      mint0   = cand->t0;
      minsignal = cand->signal;
      minback   = cand->back;
      miniha    = cand->iha;
      minidec   = cand->idec;
    }
  //}

  

  /* Print out best result from the last data block if <PUBLISH_THRESHOLD */
  /* this avoids the abundance of reports that come from the oversampling */

  if(SOCKET) min_rate = 100.; //more frequent emails from socket
  else min_rate = 50.;

  /*AIM test */
  /* min_rate = 100000.0; */
  /* end AIM test */

  if (*ipublish == 2 && minprob<min_rate*prob->publish_threshold[cand->idur]) {
	printf("burst is published at iha=%d, idec=%d, dur=%d\n", iha_print, idec_print,duration_print);
    sprintf(str,
	    "Best Publish: %5.1f %5.1f %5.1f %12.6f %9.6f %5d %12.6f %10g %10g\n",
	    minra,mindec,minha,mint0,cand->duration,minsignal,minback,minprob,
	    minprob/(prob->publish_threshold[cand->idur]/365.));
    grb_finder_logger(str);
    hid+=1;
    sprintf(title,
	    "GRB MAP: JD=%d t0=%f,Dt=%9.6f,RA=%5.1f,dec=%5.1f,Sig=%d,Back=%f,P=%g",
            cand->julDate+50000,mint0,cand->duration,
	    minra,mindec,minsignal,minback,minprob);
    racorr=1./cos(mindec*DEG_TO_RAD);
    numbin=(int)ceil(Delta(90.-mindec,minra,90.-mindec,minra+5.*racorr))+5;
    HBOOK2(hid,title,100,minra-5.*racorr,minra+5.*racorr,100,mindec-5.,mindec+5.,0.);
    HBOOK1(hid+1000,title,100,-50.*cand->duration,50.*cand->duration,0.);
    HBOOK1(hid+2000,title,100,-5.*cand->duration,5.*cand->duration,0.);
    HBOOK1(hid+3000,title,100,-50.*cand->duration,50.*cand->duration,0.);
    HBOOK1(hid+4000,title,100,-5.*cand->duration,5.*cand->duration,0.);
    HBOOK1(hid+5000,title,numbin*2,-0.25,numbin-0.25,0.);
    HBOOK1(hid+6000,title,numbin*2,-0.25,numbin-0.25,0.);
    iev=cand->nTail;
    if ((cand->nTail+cand->nBuff)>EVBUFFSIZE) {
      local_nTail=cand->nTail+cand->nBuff-EVBUFFSIZE;
      local_nBuff=EVBUFFSIZE;
    } else {
      cand->nTail=0;
      local_nBuff=cand->nBuff+cand->nTail;
    }
    
    for (i=0;i<local_nBuff;i++) {
      if (evbuffer[iev].time>mint0 && evbuffer[iev].time<mint0+cand->duration) {
        xra  = (((float)evbuffer[iev].ira)+.5)*BINSIZE;
        xdec = (((float)evbuffer[iev].idec)+.5)*BINSIZE-60.;
	    rbin=(int)ceil(Delta(90.-mindec,minra,90.-xdec,xra)/0.5)-1;
	    if(rbin<numbin*2){
		  nrad[rbin]++;
		  HFILL(hid,xra,xdec,1.);
		}
      }
      inbin = 1;
      nhabins = (int) (((float)SEARCHBIN)/cos(mindec*DEG_TO_RAD) +.5 );
      if (abs(evbuffer[iev].iha-miniha)>nhabins)   inbin=0;
      if (abs(evbuffer[iev].idec-minidec)>SEARCHBIN) inbin=0;
      if (inbin) {
        HFILL(hid+1000,evbuffer[iev].time-mint0,0.,1.);
        HFILL(hid+2000,evbuffer[iev].time-mint0,0.,1.);
	
      }
      HFILL(hid+3000,evbuffer[iev].time-mint0,0.,1.);
      HFILL(hid+4000,evbuffer[iev].time-mint0,0.,1.);
      iev++;
      if (iev>=EVBUFFSIZE) iev=0;
    }

    for(i=1;i<numbin*2;i++){

      area1=2*3.14159*(1-cos(((i-1)*0.5)*DEG_TO_RAD));
      area2=2*3.14159*(1-cos((i*0.5)*DEG_TO_RAD));
      
      if(i==1)
	HFILL(hid+6000,(i-1)*0.5,0,nrad[i-1]/area2);
      else 
	HFILL(hid+6000,(i-1)*0.5,0,nrad[i-1]/(area2-area1));
      
      HFILL(hid+5000,(i-1)*0.5,0.,nrad[i-1]);
    }

    /* generate GRB notification e-mail, if once per year prob encountered */
    if (*ipublish == 2 && minprob<(50.*prob->publish_threshold[cand->idur]/365.)) {

      type=1;
      hour   = (int) mint0/3600.;
      minute = (int) ( mint0 - ((double)hour*3600.))/60.;
      second = ( mint0 - ((double)hour*3600.) - ((double)minute*60.));
      ra_hr  = (int) (minra/15.);
      ra_mi  = (int) (minra - ((float)ra_hr*15.))*4.;
      ra_se  = (int) (minra - ((float)ra_hr*15.) - ((float)ra_mi)/4.)*240.;
      zangle = Delta(90.-35.8784722,0.,90.-mindec,minha);
      doy    = (cand->julDate-1910) % 365;  /* this will work until 2004 */
      j2c(cand->julDate,&month,&day,&year,&hh);

      if(SHORTER){
	sprintf(filename,
		"%s/email_notice/NOTICE_ULTRASHORT_%05d_%03da.txt",
		dir,cand->julDate+10000,hid-2000);
	sprintf(filename2,
		"%s/email_notice/NOTICE_ULTRASHORT_%05d_%03db.txt",
		dir,cand->julDate+10000,hid-2000);
	sprintf(pname,"%s/grb_ultrashort_cand_%05d_%03d.his",
		dir,cand->julDate+10000,hid-2000);
	sprintf(rname,"%s/grb_ultrashort_cand_%05d_%03d.root",
		dir,cand->julDate+10000,hid-2000);
	sprintf(psname,
		"%s/cand/grb_ultrashort_cand_%05d_%03d.ps",
		pubdir,cand->julDate+10000,hid-2000);
	ultra=1;
      }
      else{
	sprintf(filename,"%s/email_notice/NOTICE_SHORT_%05d_%03da.txt",
		dir,cand->julDate+10000,hid-2000);
	sprintf(filename2,"%s/email_notice/NOTICE_SHORT_%05d_%03db.txt",
		dir,cand->julDate+10000,hid-2000);
	sprintf(pname,"%s/grb_short_cand_%05d_%03d.his",
		dir,cand->julDate+10000,hid-2000);
	sprintf(rname,"%s/grb_short_cand_%05d_%03d.root",
		dir,cand->julDate+10000,hid-2000);
	sprintf(psname,
		"%s/cand/grb_short_cand_%05d_%03d.ps",
		pubdir,cand->julDate+10000,hid-2000);
	ultra=0;
      }
      
      //make a trigger ID
      
      //read trigger number
      
      sprintf(mname,"%s/grbtrig",dir);
      fpt=fopen(mname,"r");
      fscanf(fpt,"%d\n",&trignum);
      fclose(fpt);
  
      //write trigger number
    
      
      fpt=fopen(mname,"w");
      fprintf(fpt,"%d\n",trignum+1);
      fclose(fpt);
      


      fp = fopen(filename,"w");
      fprintf(fp,"\n");
      fprintf(fp,"TITLE:             MILAGRO BURST POSITION NOTICE\n");
      fprintf(fp,"NOTICE_TYPE:       MILAGRO Short Preliminary\n");
      fprintf(fp,"TRIGGER_NUM:       %d\n",trignum);
      fprintf(fp,
	         "GRB_DATE:          %5d TJD;     %3d DOY;    %0.2d/%0.2d/%4d\n",
	          cand->julDate+10000,doy,month,day,year);
      fprintf(fp,"GRB_TIME:          %7.6f SOD; {%02d:%02d:%7.6f} UT\n",mint0,hour,minute,second);
      fprintf(fp,"GRB_RUN_INFO:      RUN %d       SUBRUN %d\n",cand->runum,cand->subrunum);
      fprintf(fp,"GRB_DURATION:      %6.5f SEC\n",cand->duration);
      fprintf(fp,"GRB_MIL_RA:        %3.1f DEG {%02dh:%02dm:%02ds}\n",minra,ra_hr,ra_mi,ra_se);
      fprintf(fp,"GRB_MIL_DEC:       %3.1f DEG \n",mindec);
      fprintf(fp,"GRB_SIGNAL:        %d EVENTS\n",minsignal);
      fprintf(fp,"GRB_BACKGROUND:    %6.5f EVENTS\n",minback);
      fprintf(fp,"GRB_SIGNIFICANCE:  %g (pre trials)\n",minprob);
      fprintf(fp,"GRB_SIGNIFICANCE:  EST ANNUAL RATE (post trials):   %g\n",
	      minprob/(prob->publish_threshold[cand->idur]/365.));
      fprintf(fp,"GRB_MIL_ZEN:       %3.1f DEG\n",zangle);
      if(SOCKET)fprintf(fp,
		 "COMMENTS:          To view plots from this event go to http://umdgrb.umd.edu/milagro/daq/grb.html\n");
      else fprintf(fp,
		 "COMMENTS:          To view plots from this event go to http://umdgrb.umd.edu/cosmic/grb.html\n");
      fprintf(fp,"COMMENTS:          For more information contact David Noyes:\n");
      fprintf(fp,"COMMENTS:          WORK: 301-405-6001\n");
      fprintf(fp,"COMMENTS:          HOME: 301-345-9246\n");
      fprintf(fp,"COMMENTS:          EMAIL: dnoyes@umdgrb.umd.edu\n");
      myt = time(NULL);
      strftime(atime,100,"%Y-%m-%d %H:%M:%S UT", gmtime(&myt));
      sscanf(atime,"%04d-%02d-%02d %02d%s",&year2, &month2, &day2, &hour2, tcrap);
      fprintf(fp,
	      "COMMENTS:          This email was generated on %02d-%02d-%04d at %02d%s UT\n",
      	      month2,day2,year2,hour2,tcrap);
      fclose (fp);

      //put your email here
      sprintf(command,"mail xiaojian@cs.nyu.edu -s 'MILAGRO BURST POSITION NOTICE' <%s\n",
              filename);
      system(command);

      sprintf(str,"e-mail notification sent\n %s\n",command);
      grb_finder_logger(str);
      
      sprintf(chfield,"N");
      HRPUT(hid+6000,pname,chfield);
      sprintf(chfield,"U");
      HRPUT(hid+5000,pname,chfield);
      HRPUT(hid+4000,pname,chfield);
      HRPUT(hid+3000,pname,chfield);
      HRPUT(hid+2000,pname,chfield);
      HRPUT(hid+1000,pname,chfield);
      HRPUT(hid,pname,chfield);


      sprintf(pcommand,
	      "%s/grb_finder_plotter %d %d %d %d %d %d %d %d %lf %lf %lf %lf %d %lf %g %lf %d %d &",
	      cdir,hid,cand->julDate,ultra,type,month,day,year,NDUR,cand->duration,minra,mindec,
	      zangle,minsignal,minback,minprob,minprob/(prob->publish_threshold[cand->idur]/365.),
	      cand->runum,cand->subrunum);
      system(pcommand);
      sprintf(str,"plotter command executed:\n %s\n",pcommand);
      grb_finder_logger(str);
      
      sprintf(mname,"%s/email_notice/tmp",dir);
      fp2=fopen(mname,"w");
      //      fprintf(fp2,"FOLLOW UP COMMENTS:          This was/was not a grb because.\n");
      fclose(fp2);
      sprintf(command,"cat %s email_notice/tmp > %s",filename,filename2);
      system(command);
     
    }
    minprob=1.;
  }
  
}
