
#include "SATNode.h"
#include <math.h>


SATNode::SATNode() : _cost(-1.0)
{
}

SATNode::SATNode(const SATNode& node)
{
	_hs = node._hs;
	_hstruct = node._hstruct;
	_alarmProb = node._alarmProb;
	_cost = node._cost;
	_idstring = node._idstring;
}

SATNode& SATNode::operator=(const SATNode& node)
{
	if (this != &node)
	{
		_hs = node._hs;
		_hstruct = node._hstruct;
		_alarmProb = node._alarmProb;
		_cost = node._cost;
		_idstring = node._idstring;
	}
	return *this;
}

SATNode::~SATNode()
{
}

void SATNode::generateNextNodes(vector<SATNode*>& candNodes) const
{
	int candh, cands, dh, ds, toph, tops;
	int numLayer = _hs.size();
	toph = _hs[numLayer-1].first;
	tops = _hs[numLayer-1].second;

	SATNode* nodeBuf = NULL;

	for (int layer = numLayer-1; layer >= 0; -- layer)
	{
		dh = _hs[layer].first;
		ds = _hs[layer].second;

		if ( (dh%tops)%ds == 0			// this layer can be added to the top layer
				&& dh >= toph/20)		// prune
		{
			candh = toph + dh;
			if (candh % 2 == 0)
			for (cands = tops; cands <= dh+1; cands += tops)
				if (cands != 1 && cands >= candh/64)		// prune
			{
				// add to top layer
				vector<int> hstruct;
				hstruct.push_back( dh );
				hstruct.push_back( toph );

				SATNode* satNode = new SATNode(*this);
				satNode->addLayer( candh, cands, hstruct );
				candNodes.push_back( satNode );

				// recursively to lower layers
				int l = numLayer - 1;
				while (l > 0)
				{
					for (int i = hstruct.size()-1; i >= 0; -- i)
						if (hstruct[i] == _hs[l].first)
						{
							hstruct.erase(hstruct.begin()+i);
							hstruct.insert(hstruct.begin()+i, _hstruct[l].begin(), _hstruct[l].end());
						}

					if (NULL == nodeBuf)
					{
						nodeBuf = new SATNode[numLayer-1];
						for (int i = 1; i < numLayer; ++ i)
							for (int j = 0; j < i; ++ j)
							{
								nodeBuf[i-1]._hs.push_back( _hs[j] );
								nodeBuf[i-1]._hstruct.push_back( _hstruct[j] );
								nodeBuf[i-1]._alarmProb.push_back( 0.0 );
							}
					}

					satNode = new SATNode( nodeBuf[l-1] );
					satNode->addLayer( candh, cands, hstruct );
					candNodes.push_back( satNode );

					-- l;
				}
			}
		}
	}

	delete [] nodeBuf;
}


void SATNode::output(ostream& ofs)
{
	int i, j;
	ofs << _hs.size() << " " << _hs[_hs.size()-1].first << endl;
	for (i = 0; i < _hs.size(); ++ i)
	{
		ofs << _hs[i].second << " " << _hs[i].first << " ";
		for (j = 0; j < _hstruct[i].size(); ++ j)
			ofs << _hstruct[i][j] << " ";
		ofs << endl;
	}
	ofs << endl;
}

string SATNode::tostring()
{
	string s;
	char buf[512];
	sprintf(buf, "%d|%d|", _hs.size(), _hs[_hs.size()-1].first);
	s += buf;
	for (int i = 0; i < _hs.size(); ++ i)
	{
		sprintf(buf, "%d:%d:", _hs[i].second, _hs[i].first);
		s += buf;
		for (int j = 0; j < _hstruct[i].size(); ++ j)
		{
			sprintf(buf, "%d:", _hstruct[i][j]);
			s += buf;
		}
		s += "|";
	}
	return s;
}

double SATNode::density() const
{
	int numNode = 0, numLayer = _hs.size();
	for (int i = 0; i < numLayer; ++ i)
		numNode += _hs[numLayer-1].second/_hs[i].second;
	return numNode/(double)(_hs[numLayer-1].second);
}

