#ifndef SATFINDER_H
#define SATFINDER_H

#include <vector>
#include <set>
#include <string>
#include "SATNode.h"


using namespace std;

class SATFinder
{
public:
	SATFinder();
	virtual ~SATFinder();

	void searchSAT(char* thresFile, char* sampleFile, char* satFile);
	void setSearchParam(int expandSetSize, int numFinalNodeToStop);
	void clean();

	long _totalRunTime;

private:
	void stateSpaceSearch();
	double getTheoCost(SATNode* satNode);

	int loadThresholds(const char* thresFile);
	int loadSampleData(const char* sampleFile);
	void sampleStat();

	void insertToFrontier(SATNode* node);
	void removeFromFrontier(SATNode* node);

private:
	// thresholds
	vector<pair<int, double> > _thresholds;
	int		_maxWinSize;

	// sample data
	long	_numSampleData;
	double*	_sampleData;
	double	_mean;
	double  _stddev;
	double* _ap;

	// search
	set<string>			_visitedNodes;
	vector<SATNode*>	_frontier;
	vector<int>			_numExpandedByOverlapWinSize;
	vector<vector<SATNode*> >	_frontierByOverlapWinSize;

	SATNode*	_best10SAT[10];

	int		_maxFrontierSize;
	int		_numFinalNodeToStop;

};

#endif
