/*
 * For now, just take a list of point, and show the Voronoi diagram.
 */

import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.io.*;
import java.util.*;

// Voronize will make the list of polys for a list of points
//    it also provides a display method
// main will open a frame and display the results
public class Voronize {
    public static final int W = 400;
    public static final int H = 400;
    public static final Point2D.Double UL = new Point2D.Double(  0,   0);
    public static final Point2D.Double UR = new Point2D.Double(W-1,   0);
    public static final Point2D.Double LL = new Point2D.Double(  0, H-1);
    public static final Point2D.Double LR = new Point2D.Double(W-1, H-1);
    private Vector points;
    private Vector ppolys;
    public Voronize() {
	points = new Vector();
	ppolys = new Vector();
    }
    public Vector getPoints() {
	return points;
    }
    public Vector getPPolys() {
	return ppolys;
    }
    int count;
    public void set(Vector p) {
	count = 0;
	points = p;
	ppolys = new Vector();
	for(int k = 0; k < p.size(); k++)
	    ppolys.addElement(new PolarPoly());
	for(int k = 0; k < p.size(); k++) {
	    VLine[] bis = getBisectors(k);
	    addPoint(k, bis, false);
	}
	//System.out.println("unique: " + count);
    }
    public void addPoint(Point p) {
	points.addElement(p);
	ppolys.addElement(new PolarPoly());
	VLine[] bis = getBisectors(points.size()-1);
	addPoint(points.size()-1, bis, true);
	//System.out.println("unique: " + count);
    }
    private void addPoint(int k, VLine[] bis, boolean incremental) {
	if(incremental)
	    for(int i = 0; i < bis.length-5; i++)
		prune(i, bis[i]);
	int start = incremental ? 0 : k+1;
	for(int i = start; i < bis.length-1; i++) {
	    for(int j = i+1; j < bis.length; j++) {
		Point2D.Double intpt = bis[i].getIntersection(bis[j]);
		if(intpt != null) {
		    Point ctr = (Point)points.elementAt(k);
		    VLine testint = new VLine(ctr.x, ctr.y, intpt.x, intpt.y);
		    if(isGood(k, i, j, testint, intpt, bis, ctr)) {
			count++;
			((PolarPoly)ppolys.elementAt(k)).addPoint(intpt);
			if(i < bis.length-4)
			    ((PolarPoly)ppolys.elementAt(i)).addPoint(intpt);
			if(j < bis.length-4)
			    ((PolarPoly)ppolys.elementAt(j)).addPoint(intpt);
		    }
		}
	    }
	}
    }
    private boolean isGood(int k, int i, int j, VLine testint, Point2D.Double intpt, VLine[] bis, Point ctr) {
	boolean OK = true;
	int m = 0;
	do {
	    if(m!=i && m!=j && m!=k) {
		Point2D.Double xp = testint.getIntersection(bis[m]);
		if(xp!=null &&
		   Math.min(ctr.x, intpt.x) <= xp.x && xp.x <= Math.max(ctr.x, intpt.x) &&
		   Math.min(ctr.y, intpt.y) <= xp.y && xp.y <= Math.max(ctr.y, intpt.y))
		    OK = false;
	    }
	    m++;
	} while(OK && m<bis.length);
	return OK;
    }
    private void prune(int index, VLine line) {
	PolarPoly pp = (PolarPoly)ppolys.elementAt(index);
	Point pt = (Point)points.elementAt(index);
	double goodside = line.eval(pt);
	int N = pp.getSize();
	for(int i = N-1; i >=0; i--) {
	    Point2D.Double p = pp.getPoint(i);
	    double e = line.eval(p);
	    if(Math.abs(e) < .01)
		e = 0;
	    if(e*goodside < 0)
		pp.removePoint(i);
	    //	    if(e*goodside < 0)
	    //		System.out.println("pt: " + pt + ", fac: " + (e*goodside));
	}
	//	if(N-pp.getSize() > 0)
	//	    System.out.println("removed from " + index + ": " + (N-pp.getSize()));
    }
    // find perpendicular bisectors of points[index]
    // add screen edge bisectors
    private VLine[] getBisectors(int index) {
	VLine[] lines = new VLine[points.size()+4];
	int i;
	Point tmp = (Point)points.elementAt(index);
	for(i = 0; i < points.size(); i++)
	    lines[i] = getPerpBisect(tmp, (Point)points.elementAt(i));
	lines[i++] = new VLine(UL, UR);
	lines[i++] = new VLine(UR, LR);
	lines[i++] = new VLine(LR, LL);
	lines[i++] = new VLine(LL, UL);
	return lines;
    }
    // get the perpendicular bisector of the line between p1 and p2
    private VLine getPerpBisect(Point2D.Double p1, Point2D.Double p2) {
	Point2D.Double center = new Point2D.Double((p1.x+p2.x)/2.0, (p1.y+p2.y)/2.0);
	Point2D.Double newp1 = new Point2D.Double(-(p1.y-center.y)+center.x, p1.x-center.x+center.y);
	Point2D.Double newp2 = new Point2D.Double(-(p2.y-center.y)+center.x, p2.x-center.x+center.y);
	return new VLine(newp1, newp2);
    }
    private VLine getPerpBisect(Point p1, Point p2) {
	return getPerpBisect(new Point2D.Double(p1.x, p1.y), new Point2D.Double(p2.x, p2.y));
    }
    private static Vector readPoints(String filename) throws IOException {
	BufferedReader in = new BufferedReader(new FileReader(filename));
	Vector v = new Vector();
	String line;
	while((line = in.readLine()) != null) {
	    StringTokenizer t = new StringTokenizer(line);
	    int x = Integer.parseInt(t.nextToken());
	    int y = Integer.parseInt(t.nextToken());
	    v.addElement(new Point(x, y));
	}
	return v;
    }

    public static void main(String[] args) {
	if(args.length > 1) {
	    System.err.println("usage: Voronize [filename]");
	    System.exit(1);
	}
	Voronize v = new Voronize();
	if(args.length == 1) {
	    try {
		Vector pts = readPoints(args[0]);
		v.set(pts);
	    }
	    catch(IOException ie) {
		System.err.println("file read error!");
	    }
	}
	Frame f = new Frame("Voronoi Diagram");
	f.addWindowListener(new WindowAdapter() {
		public void windowClosing(WindowEvent e) {
		    System.exit(0);
		}
	    });
	f.setLayout(new BorderLayout());
	VPanel vp = new VPanel(v);
	vp.setPreferredSize(new Dimension(W, H));
	Color[] colors = { new Color(255, 200, 200),
			   new Color(200, 200, 255)
			       };
	vp.setColors(colors);
	f.add(vp, BorderLayout.CENTER);
	f.pack();
	f.setVisible(true);
    }
}
