import java.awt.*;
import java.awt.event.*;
import java.util.*;

public class VPanel extends Panel {
    private Voronize v;
    private boolean singlePoly;
    private int showPoly;
    private Color[] colors = { Color.red, Color.blue };
    private Dimension pref;
    public VPanel(Voronize v) {
	super();
	this.v = v;
	pref = new Dimension(400, 400);
	singlePoly = false;
	showPoly = 0;
	class VPanelKey extends KeyAdapter {
	    private VPanel vp;
	    public VPanelKey(VPanel vp) {
		this.vp = vp;
	    }
	    public void keyPressed(KeyEvent e) {
		switch(e.getKeyChar()) {
		case 'l':
		    vp.setSinglePoly(!vp.getSinglePoly());
		    break;
		case 'j':
		    vp.setShowPoly(vp.getShowPoly()-1);
		    break;
		case 'k':
		    vp.setShowPoly(vp.getShowPoly()+1);
		    break;
		}
	    }
	}
	this.addKeyListener(new VPanelKey(this));
	class VPanelMouse extends MouseAdapter {
	    private VPanel vp;
	    private Voronize vo;
	    public VPanelMouse(VPanel vp, Voronize vo) {
		this.vp = vp;
		this.vo = vo;
	    }
	    public void mouseReleased(MouseEvent e) {
		Point p = e.getPoint();
		if((e.getModifiers()&InputEvent.BUTTON1_MASK) != 0) {
		    if(p.x>=0 && p.x<Voronize.W && p.y>=0 && p.y<Voronize.H) {
			Vector points = vo.getPoints();
			if(!points.contains(p)) {
			    vo.addPoint(e.getPoint());
			    vp.repaint();
			}
		    }
		} else if((e.getModifiers()&InputEvent.BUTTON3_MASK) != 0) {
		    Vector ppolys = vo.getPPolys();
		    for(int i = 0; i < ppolys.size(); i++) {
			PolarPoly pp = (PolarPoly)ppolys.elementAt(i);
			if(pp.getPolygon().contains(p)) {
			    System.out.println("poly: " + i + ", area: " + pp.area());
			    break;
			}
		    }
		} else if((e.getModifiers()&InputEvent.BUTTON2_MASK) != 0) {
		    Vector points = vo.getPoints();
		    for(int i = 0; i < points.size(); i++) {
			Point plp = (Point)points.elementAt(i);
			System.out.println(plp.x + " " + plp.y);
		    }
		}
	    }
	}
	this.addMouseListener(new VPanelMouse(this, v));
    }
    public void setColors(Color[] c) {
	colors = c;
    }
    public void paint(Graphics g) {
	update(g);
    }
    public void update(Graphics g) {
	Vector points = v.getPoints();
	Vector ppolys = v.getPPolys();
	g.clearRect(0, 0, getSize().width, getSize().height);
	g.setColor(getForeground());
	if(showPoly>=ppolys.size())
	    showPoly -= ppolys.size();
	else if(showPoly<0)
	    showPoly += ppolys.size();
	if(singlePoly)
	    System.out.println("displaying: " + showPoly);
	int start = singlePoly ? showPoly : 0;
	int end = singlePoly ? showPoly+1 : ppolys.size();
	double area = 0;
	for(int i = start; i < end; i++) {
	    Point pnt = (Point)points.elementAt(i);
	    PolarPoly pp = (PolarPoly)ppolys.elementAt(i);
	    area += pp.area();
	    Polygon poly = pp.getPolygon();
	    g.setColor(colors[i%colors.length]);
	    g.fillPolygon(poly);
	    g.setColor(Color.black);
	    g.drawPolygon(poly);
	    g.setColor(Color.black);
	    g.fillOval(pnt.x-3, pnt.y-3, 7, 7);
	}
	System.out.println("area: " + area);
    }
    public Dimension getPreferredSize() {
	return pref;
    }
    public void setPreferredSize(Dimension d) {
	pref = d;
    }
    public boolean getSinglePoly() {
	return singlePoly;
    }
    public void setSinglePoly(boolean b) {
	singlePoly = b;
	repaint();
    }
    public int getShowPoly() {
	return showPoly;
    }
    public void setShowPoly(int p) {
	showPoly = p;
	repaint();
    }
}
