/**
 * StratPal
 * @author Dennis Shasha
 * @author Anastasia Kuznetsov
 * 10/01/2005
 */

package StratPal;


import java.lang.String;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;


public class QNode{

	/** String representation of the question content. */
	private String question;
	
	/** Name of question. */
	private String name;
	
	/** Answer given by witness. */
	private String keyword;
	
	/** Conditions to get to this question. */
	private HashMap conditions;
		
	/**
	 * Mapping of question's response keywords to corresponding
	 * followup questions.
	 */
	private LinkedList answers;
	
	/** Direct children. */
	private LinkedList children;
	
	/** Iterator over the kids. */
	private ListIterator childIter;
	

	/** Go To statements. */
	private LinkedList goTos;
	
	/** Number of new lines in this quesition. */
	private int numNewLines;
	
	/** Is this the current question. */
	private boolean isCurrent = false;
	
	
	/** Has this question been skipped. */
	private boolean skipped = false;
	
	/** Indent level. */
	private int indent=0;
	

	/**
	 * Create node with specified name and question text.
	 * @param initName name of question.
	 * @param Question text.
	 */
	public QNode(String initName, String initQuestion){
		name = initName;
		question= initQuestion;
		answers = new LinkedList();
		keyword ="";
		children = new LinkedList();
		conditions = new HashMap();
		childIter = children.listIterator();
		goTos = new LinkedList();
		numNewLines =0;
	
		
	}

	/**
	 * Adds answer to question.
	 * @param answer keyword answer.
	 * @param questionName name of followup question that should be asked if that answer
	 * was given.
	 */
	public void addAnswer(String answer){
		answers.add(answer);
	}
	
	/**
	 * @return All answers.
	 */
	public Object [] getAnswers(){
		if(answers.isEmpty())
			answers.addLast("next");
		else if(answers.size() == 1)
			answers.addLast("other than "+(String)answers.getFirst());
		else
			answers.addLast("other");
		Object[] out = answers.toArray();
		answers.removeLast();
		
		return out;
	}
	

	/**
	 * Gets actual contents of question.
	 * @return question text.
	 */
	public String getText() {
		return question;
	}
	
	/**
	 * Gets name of question.
	 * @return  name of question.
	 */
	public String getName() {
		return name;
	}
	
	/**
	 * Checks if question has the given answer as a valid answer.
	 * @param answer keyword
	 * @return true if question contains this answer.
	 */
	public boolean containsAnswer(String answer){
		return answers.contains(answer);
		
	}

	/**
	 * Gets number of possible answers to question.
	 * @return number of answers in the question.
	 */
	public int numAnswers() {
		return answers.size();
	}

	/**
	 * Sets keyword as selected answer to question.
	 * @param word keyword to be set as answer.
	 */
	public void setKeyword(String word){
		keyword = word;
	}
	
	/**
	 * Checks if question has been answered with the given answer.
	 * @param kword answer
	 * @return true if question was answered
	 */
	public boolean wasAnswered(String kword){
		return (keyword.compareTo(kword)==0);
	}
	
	/**
	 * Adds child (subquestion) to this question.
	 * @param child subquestion that follows this quesiton. 
	 */
	public void addChild(String child){
		children.addLast(child);
	}
	
	/**
	 * Checks if question has children (subquestions).
	 * @return true if it has children (subquestions)
	 */
	public boolean hasChildren(){
		return childIter.hasNext();
	}

	/**
	 * Gets iterator over this question's children (subquestions).
	 * @return iterator over the list of this questions's children (subquestions).
	 */
	public ListIterator getChildIter(){
		return children.listIterator();
	}
	
	/**
	 * Adds condition to this question.
	 * @param question question that should have the answer.
	 * @param condition answer being tested.
	 */
	public void addCondition(String question, String condition){
		conditions.put(question, condition);
	}
	
	/**
	 * Checks if this question has any conditions.
	 * @return true if it has conditions.
	 */
	public boolean hasConditions(){
		return !conditions.isEmpty();
	}

	/**
	 * Gets conditions associated with this question.
	 * @return hashmap of conditions.
	 */
	public HashMap getConditions() {
		return conditions;
	}

	/**
	 * Adds go to statements to this quesitons.
	 * @param to name of question that must be answered with the specified answer
	 * @param kword answer under which go to that questions.
	 * @param goTo	name of question that deposition goes to
	 */
	public void addGoTo(String to, String kword, String goTo) {
		GoTo gt = new GoTo(to, kword, goTo);
		goTos.add(gt);
		
	}

	/**
	 * Checks if this question has go to statements.
	 * @return true if it has go to statements.
	 */
	public boolean hasGoTo(){
		return (goTos.size()>0);
	}

	/**
	 * Gets iterator over this questions go-to statement list.
	 * @return ListIterator over go-to's
	 */
	public ListIterator goToIter(){
		return goTos.listIterator();
	}

	/**
	 * Get number of new lines
	 * @return number of new lines
	 */
	public int getNewLines() {
		return numNewLines;
	}
	
	/**
	 * Sets number of new lines in this question (line breaks).
	 * @param lines number of line breaks.
	 */
	public void setNewLines(int lines){
		numNewLines = lines;
	}
	
	/**
	 * Set this question as current- ie currently being asked
	 * @param val if true- this question is current
	 */
	public void setCurrent(boolean val){
		isCurrent = val;
	}
	
	/**
	 * Check if this question is current
	 * @return true if its current
	 */
	public boolean isCurrent(){
		return isCurrent;
	}
	
	/**
	 * Set this question as skipped.
	 * @param val true if it's skipped.
	 */
	public void setSkipped(boolean val){
		skipped = val;
	}
	
	/**
	 * Checks if this question is skipped.
	 * @return true if skipped
	 */
	public boolean isSkipped(){
		return skipped;
	}

	/**
	 * Checks if is answered.
	 * @return true if answered.
	 */
	public boolean isAnswered() {
		
		return (!(keyword.compareTo("") == 0));
	}
	
	/**
	 * Gets answer to this question.
	 * @return keyword that was selected as this question's answer.
	 */
	public String getAnswer(){
		return keyword;
	}
	
	/**
	 * Increment indentation.
	 * @param i the specified indentation increment amount.
	 */
	public void incrementIndent(int i){
		indent +=i;
	}
	
	/**
	 * Get question's indentation.
	 * @return int- indentation amount.
	 */
	public int getIndent(){
		return indent;
	}


}