import java.awt.*;
import java.util.*;

public class Spy {
    public static final double RICH_BREAK_IN_PROB = 0.99999;
    public static final double POOR_BREAK_IN_PROB = 0.00001;

    public boolean[] knows;
    public boolean[] can_get;
    public int[] goods_count;
    public int n;
    public int m;
    public double f;
    public int v;
    public int visits_left;
    public int info_needed;
    public int info_so_far;
    public boolean has_won;
    public Random r;

    public static final int CITY_SIZE = 200;
    public static final double CROSS_OVER_PROB = 0.9;
    public static final double MUTATE_PROB = 0.1;

    public int[][][] parent_city;
    public int[][] parent_pon;
    public int[][] parent_size;
    public int[] parent_fitness;

    public int[][][] kid_city;
    public int[][] kid_pon;
    public int[][] kid_size;
    public int[] kid_fitness;

    public int[][][] super_city;
    public int[][] super_pon;
    public int[][] super_size;
    public int[] super_fitness;

    public static final double HIDDEN_OFFSET_X = -10.0;
    public static final double HIDDEN_OFFSET_Y = -10.0;

    public static final int NUM_POLYGONS = 5;
    public static final int NUM_FACE_SIDES = 20;
    public static final double FACE_RADIUS = 20.0;

    public Color c;
    public double main_length;
    public double[][][] initial_coordinates;
    public Matrix_3x3[] polygon_matrices;
    public Matrix_3x3 viewing_matrix;
    public int[][][] appearance_coordinates;

    public double scale_value;
    public double[] offset;

    public House h;

    public Spy(int n, int m, double f, int v, double scale, double x, double y) {
	int i, j, k;

	this.n = n;
	this.m = m;
	this.f = f;
	this.v = v;
	this.visits_left = v;
	this.info_needed = PsuedoRandom.ceiling(n * f);
	this.info_so_far = 0;
	this.has_won = false;

	this.knows = new boolean[n + 1];
	for (i = 0; i < this.knows.length; i++) {
	    this.knows[i] = false;
	}
	this.can_get = new boolean[n + 1];
	this.goods_count = new int[m + 1];
	this.r = new Random();

	this.c = Color.red;
	this.scale_value = scale;
	this.main_length = scale_value * FACE_RADIUS;

	this.initial_coordinates = new double[NUM_POLYGONS][][];
	this.polygon_matrices = new Matrix_3x3[NUM_POLYGONS];

	this.initial_coordinates[0] = new double[2][NUM_FACE_SIDES];
	FunShapes.makePolygon(main_length, initial_coordinates[0]);
	polygon_matrices[0] = new Matrix_3x3();
	polygon_matrices[0].identity();
	// scale
	polygon_matrices[0].translate(0.0   , 2.0 * main_length   );

	this.initial_coordinates[1] = new double[2][4];
	initial_coordinates[1][0][0] = 0.0;                  initial_coordinates[1][1][0] = 0.0;
	initial_coordinates[1][0][1] = 0.25 * main_length;   initial_coordinates[1][1][1] = 0.0;
	initial_coordinates[1][0][2] = 0.25 * main_length;   initial_coordinates[1][1][2] = 2.0 * main_length;
	initial_coordinates[1][0][3] = 0.0;                  initial_coordinates[1][1][3] = 2.0 * main_length;
	polygon_matrices[1] = new Matrix_3x3();
	polygon_matrices[1].identity();
	// scale
	polygon_matrices[1].translate(-0.125 * main_length   , 0.0 * main_length   );

	this.initial_coordinates[2] = new double[2][4];
	initial_coordinates[2][0][0] = 0.0;                  initial_coordinates[2][1][0] = 0.0;
	initial_coordinates[2][0][1] = 2.0 * main_length;    initial_coordinates[2][1][1] = 0.0;
	initial_coordinates[2][0][2] = 2.0 * main_length;    initial_coordinates[2][1][2] = 0.25 * main_length;
	initial_coordinates[2][0][3] = 0.0;                  initial_coordinates[2][1][3] = 0.25 * main_length;
	polygon_matrices[2] = new Matrix_3x3();
	polygon_matrices[2].identity();
	// scale
	polygon_matrices[2].translate(-1.0 * main_length   , 0.65 * main_length   );

	this.initial_coordinates[3] = new double[2][4];
	initial_coordinates[3][0][0] = 0.0;                  initial_coordinates[3][1][0] = 0.0;
	initial_coordinates[3][0][1] = 0.25 * main_length;   initial_coordinates[3][1][1] = 0.0;
	initial_coordinates[3][0][2] = 0.25 * main_length;   initial_coordinates[3][1][2] = 1.0 * main_length;
	initial_coordinates[3][0][3] = 0.0;                  initial_coordinates[3][1][3] = 1.0 * main_length;
	polygon_matrices[3] = new Matrix_3x3();
	polygon_matrices[3].identity();
	// scale
	polygon_matrices[3].rotate(2.0 * Math.PI / 3.0);
	polygon_matrices[3].translate(0.0   , 0.0 * main_length   );

	this.initial_coordinates[4] = new double[2][4];
	initial_coordinates[4][0][0] = 0.0;                  initial_coordinates[4][1][0] = 0.0;
	initial_coordinates[4][0][1] = 0.25 * main_length;   initial_coordinates[4][1][1] = 0.0;
	initial_coordinates[4][0][2] = 0.25 * main_length;   initial_coordinates[4][1][2] = 1.0 * main_length;
	initial_coordinates[4][0][3] = 0.0;                  initial_coordinates[4][1][3] = 1.0 * main_length;
	polygon_matrices[4] = new Matrix_3x3();
	polygon_matrices[4].identity();
	// scale
	polygon_matrices[4].translate(0.0   , -1.0 * main_length   );
	polygon_matrices[4].rotate(1.0 * Math.PI / 3.0);
	polygon_matrices[4].translate(0.0   , 0.0 * main_length   );

	this.viewing_matrix = new Matrix_3x3();
	this.appearance_coordinates = new int[this.initial_coordinates.length][][];
	for (i = 0; i < this.appearance_coordinates.length; i++) {
	    this.appearance_coordinates[i] = new int[this.initial_coordinates[i].length][];
	    for (j = 0; j < this.appearance_coordinates[i].length; j++) {
		this.appearance_coordinates[i][j] = new int[this.initial_coordinates[i][j].length];
		for (k = 0; k < this.appearance_coordinates[i][j].length; k++) {
		    this.appearance_coordinates[i][j][k] = 0;
		}
	    }
	}

	this.offset = new double[2];
	offset[0] = x + HIDDEN_OFFSET_X;
	offset[1] = y + HIDDEN_OFFSET_Y;

	this.h = new House(scale, x, y, "S");
	this.h.c = Color.pink;

	this.parent_city = new int[CITY_SIZE][m ][n ];
	this.parent_pon = new int[CITY_SIZE][m ];
	this.parent_size = new int[CITY_SIZE][m ];
	this.parent_fitness = new int[CITY_SIZE];

	this.kid_city = new int[CITY_SIZE][m ][n ];
	this.kid_pon = new int[CITY_SIZE][m ];
	this.kid_size = new int[CITY_SIZE][m ];
	this.kid_fitness = new int[CITY_SIZE];

	this.super_city = new int[2 * CITY_SIZE][m ][n ];
	this.super_pon = new int[2 * CITY_SIZE][m ];
	this.super_size = new int[2 * CITY_SIZE][m ];
	this.super_fitness = new int[2 * CITY_SIZE];
    }

    public void goToWork(Situation q, int iterations) {
	int i, j, k, l;
	for (i = 0; i < CITY_SIZE; i++) {
	    q.assignBreakins();
	    for (j = 0; j < m; j++) {
		parent_pon[i][j] = q.combo_pon[j];
		parent_size[i][j] = q.combo_usize[j];
	    }

	    for (j = 0; j < m; j++) {
		for (k = 0; k < parent_size[i][j]; k++) {
		    parent_city[i][j][k] = q.combo[j][k];
		}
	    }
	    eval(i);
	}

	sort_by_fitness(parent_city, parent_pon, parent_size, parent_fitness);

	i = parent_fitness.length - 1;
	q.optimal_count = parent_fitness[i];
	for (j = 0; j < m; j++) {
	    q.optimal_pon[j] = parent_pon[i][j];
	    q.optimal_size[j] = parent_size[i][j];
	}
	
	for (j = 0; j < m; j++) {
	    for (k = 0; k < parent_size[i][j]; k++) {
		q.optimal_combo[j][k] = parent_city[i][j][k];
	    }
	}	
    }

    public void eval(int i) {
	int j;
	int count = 0;
	for (j = 0; j < m; j++) {
	    count += parent_size[i][j];
	}
	parent_fitness[i] = count;
    }

    public void sort_by_fitness(int[][][] city, int[][] pon, int[][] s, int[] fitness) {
	int j, target;
	int temp_city[][];
	int temp_pon[];
	int temp_s[];
	int temp_fitness;
	
	for (j = 0; j < fitness.length - 1; j++) {
	    target = find_min_fitness_point(fitness, j);

	    temp_city = city[target];
	    temp_pon = pon[target];
	    temp_s = s[target];	    
	    temp_fitness = fitness[target];
	    
	    city[target] = city[j];
	    pon[target] = pon[j];
	    s[target] = s[j];
	    fitness[target] = fitness[j];

	    city[j] = temp_city;
	    pon[j] = temp_pon;
	    s[j] = temp_s;
	    fitness[j] = temp_fitness;
	}	
    }

    public int find_min_fitness_point(int[] fitness, int start) {
	int j;
	int key = start;
	int min_val = fitness[start];
	
	for (j = start + 1; j < fitness.length; j++) {
	    if (fitness[j] < min_val) {
		min_val = fitness[j];
		key = j;
	    }
	}
	
	return key;	
    }

    public void peekAround(PostOffice[] po) {
	while ((has_won == false) && (makeBrake(po))) {
	}
    }

    private boolean makeBrake(PostOffice[] po) {
	int i, j, k;
	int max = 0, key = -1;
	double randy, magic_val;

	for (i = 1; i <= m; i++) {
	    goods_count[i] = 0;
	}
	
	for (i = 1; i <= m; i++) {
	    /* go thru the mailBag in each postoffice, checking if it's a msg that isn't acquired yet. 
	       If so, increment the goods_count for that office. If goods count exceeds a certain number, 
	       breakin with prob b, else breakin with prob q!
	     */
	    for (k = 1; k <= n; k++) {
		can_get[k] = false;
	    }
	    for (j = 0; j < po[i].mailBag.length; j++) {
		if (po[i].mailBag[j] != null) {
		    // && (po[i].mailBag[j].letterType == Letter.MESSAGE)) {
		    for (k = 0; k < po[i].mailBag[j].contents.length; k++) {
			if (po[i].mailBag[j].contents[k][0] == Letter.MESSAGE) {
			    can_get[po[i].mailBag[j].contents[k][1]] = true;
			}
		    }
		    // can_get[po[i].mailBag[j].personFrom] = true;
		}
	    }

	    for (k = 1; k <= n; k++) {
		if ((can_get[k] == true) && (knows[k] == false)) {
		    goods_count[i]++;
		}
	    }
	}
	
	for (i = 1; i <= m; i++) {
	    if (goods_count[i] > max) {
		max = goods_count[i];
		key = i;
	    }
	}

	magic_val = (1.0 * (info_needed - info_so_far)) / (1.0 * visits_left);

	randy = r.nextDouble();

	if ((max >= magic_val) && (randy < RICH_BREAK_IN_PROB)) {
	    breakIn(po, key);
	    return true;
	} else if ((max < magic_val) && (0 < max) && (key > 0) && (randy < POOR_BREAK_IN_PROB)) {
	    breakIn(po, key);
	    return true;
	} else {
	    // System.out.print("Spy is not making a breakin at this point.\n");
	    return false;
	}
    }

    public void breakIn(PostOffice po[], int key) {
	int j, k;
	int count = 0;
	int diff;

	System.out.print("Spy: Hey Newmann, thanks for the tipoff! I've just broken into Post Office # "+key);
	System.out.print(" and learned the plans of person(s) ");

	for (j = 0; j < po[key].mailBag.length; j++) {
	    if (po[key].mailBag[j] != null) {
		for (k = 0; k < po[key].mailBag[j].contents.length; k++) {
		    if ((po[key].mailBag[j].contents[k][0] == Letter.MESSAGE) && 
			(knows[po[key].mailBag[j].contents[k][1]] == false)) {
			knows[po[key].mailBag[j].contents[k][1]] = true;
			if (count > 0) {
			    System.out.print(", ");
			}
			System.out.print(po[key].mailBag[j].contents[k][1] + " (from Letter #"+po[key].mailBag[j].lid+")");
			count++;			
		    }  
		}
		// && (po[key].mailBag[j].letterType == 0)) {
		/*
		if (knows[po[key].mailBag[j].personFrom] == false) {		    
		    knows[po[key].mailBag[j].personFrom] = true;
		    if (count > 0) {
			System.out.print(", ");
		    }
		    System.out.print(po[key].mailBag[j].personFrom);
		    count++;
		}
		*/
	    }	    
	}

	this.visits_left--;
	this.info_so_far += count;

	diff = info_needed - info_so_far;

	if (diff > 0) {
	    System.out.print("\nSpy: Now I only need "+diff+" more pieces of info to rule the world, ");
	    System.out.print("and I've got "+visits_left+" visits left!\n");
	} else {
	    this.has_won = true;
	    System.out.print("\nSpy: (Evil cackle) I've won! The earth is mine!\n");
	}
    }

    public Color getColor() {
	return this.c;
    }    

    public int[][][] getSpyCoordinates(int screenWidth, int screenHeight) {
	int i, j;
	double [] cord;
	this.viewing_matrix.identity();
	for (i = NUM_POLYGONS - 1; i >= 0; i--) {
	    this.viewing_matrix.copyFromMatrix(this.polygon_matrices[i]);
	    this.viewing_matrix.translate2D(offset);
	    this.viewing_matrix.mathToApplet(screenWidth, screenHeight);
	    for (j = 0; j < this.initial_coordinates[i][0].length; j++) {
		cord = this.viewing_matrix.transform(this.initial_coordinates[i][0][j], this.initial_coordinates[i][1][j]);
		this.appearance_coordinates[i][0][j] = (int)Math.round(cord[0]);
		this.appearance_coordinates[i][1][j] = (int)Math.round(cord[1]);
	    }
	}
	return this.appearance_coordinates;
    }
}
