import java.awt.*;

public class Person {
    public int pid;
    public boolean hasOrders;
    public boolean eventsYet[][]; // [j][0] denotes msg from person j, [j][1] denotes ack from person j.
    public ActionList actList[];
    //    public boolean gotLetterFrom[];
    //    public boolean gotAckFrom[];

    public static final double HIDDEN_OFFSET_X = -10.0;
    public static final double HIDDEN_OFFSET_Y = -10.0;

    public static final int NUM_POLYGONS = 5;
    public static final int NUM_FACE_SIDES = 20;
    public static final double FACE_RADIUS = 20.0;

    public Color c;
    public double main_length;
    public double[][][] initial_coordinates;
    public Matrix_3x3[] polygon_matrices;
    public Matrix_3x3 viewing_matrix;
    public int[][][] appearance_coordinates;

    public double scale_value;
    public double[] offset;

    public House h;

    public Person(int n, double scale, int id, double x, double y) {
	int i, j, k;
	this.hasOrders = false;
	this.eventsYet = new boolean[n + 1][2];

	for (i = 0; i < this.eventsYet.length; i++) {
	    for (j = 0; j < this.eventsYet[i].length; j++) {
		if (i != id) {
		    this.eventsYet[i][j] = false;
		} else {
		    this.eventsYet[i][j] = true;
		}
	    }
	}
	this.pid = id;

	/*
	this.gotLetterFrom = new boolean[n + 1];
	for (i = 0; i < this.gotLetterFrom.length; i++) {
	    if (i != id) {
		this.gotLetterFrom[i] = false;
	    } else {
		this.gotLetterFrom[i] = true;
	    }
	}

	this.gotAckFrom = new boolean[n + 1];
	for (i = 0; i < this.gotAckFrom.length; i++) {
	    if (i != id) {
		this.gotAckFrom[i] = false;
	    } else {
		this.gotAckFrom[i] = true;
	    }
	}
	*/

	this.c = Color.black;
	this.scale_value = scale;
	this.main_length = scale_value * FACE_RADIUS;

	this.initial_coordinates = new double[NUM_POLYGONS][][];
	this.polygon_matrices = new Matrix_3x3[NUM_POLYGONS];

	this.initial_coordinates[0] = new double[2][NUM_FACE_SIDES];
	FunShapes.makePolygon(main_length, initial_coordinates[0]);
	polygon_matrices[0] = new Matrix_3x3();
	polygon_matrices[0].identity();
	// scale
	polygon_matrices[0].translate(0.0   , 2.0 * main_length   );

	this.initial_coordinates[1] = new double[2][4];
	initial_coordinates[1][0][0] = 0.0;                  initial_coordinates[1][1][0] = 0.0;
	initial_coordinates[1][0][1] = 0.25 * main_length;   initial_coordinates[1][1][1] = 0.0;
	initial_coordinates[1][0][2] = 0.25 * main_length;   initial_coordinates[1][1][2] = 2.0 * main_length;
	initial_coordinates[1][0][3] = 0.0;                  initial_coordinates[1][1][3] = 2.0 * main_length;
	polygon_matrices[1] = new Matrix_3x3();
	polygon_matrices[1].identity();
	// scale
	polygon_matrices[1].translate(-0.125 * main_length   , 0.0 * main_length   );

	this.initial_coordinates[2] = new double[2][4];
	initial_coordinates[2][0][0] = 0.0;                  initial_coordinates[2][1][0] = 0.0;
	initial_coordinates[2][0][1] = 2.0 * main_length;    initial_coordinates[2][1][1] = 0.0;
	initial_coordinates[2][0][2] = 2.0 * main_length;    initial_coordinates[2][1][2] = 0.25 * main_length;
	initial_coordinates[2][0][3] = 0.0;                  initial_coordinates[2][1][3] = 0.25 * main_length;
	polygon_matrices[2] = new Matrix_3x3();
	polygon_matrices[2].identity();
	// scale
	polygon_matrices[2].translate(-1.0 * main_length   , 0.65 * main_length   );

	this.initial_coordinates[3] = new double[2][4];
	initial_coordinates[3][0][0] = 0.0;                  initial_coordinates[3][1][0] = 0.0;
	initial_coordinates[3][0][1] = 0.25 * main_length;   initial_coordinates[3][1][1] = 0.0;
	initial_coordinates[3][0][2] = 0.25 * main_length;   initial_coordinates[3][1][2] = 1.0 * main_length;
	initial_coordinates[3][0][3] = 0.0;                  initial_coordinates[3][1][3] = 1.0 * main_length;
	polygon_matrices[3] = new Matrix_3x3();
	polygon_matrices[3].identity();
	// scale
	polygon_matrices[3].rotate(2.0 * Math.PI / 3.0);
	polygon_matrices[3].translate(0.0   , 0.0 * main_length   );

	this.initial_coordinates[4] = new double[2][4];
	initial_coordinates[4][0][0] = 0.0;                  initial_coordinates[4][1][0] = 0.0;
	initial_coordinates[4][0][1] = 0.25 * main_length;   initial_coordinates[4][1][1] = 0.0;
	initial_coordinates[4][0][2] = 0.25 * main_length;   initial_coordinates[4][1][2] = 1.0 * main_length;
	initial_coordinates[4][0][3] = 0.0;                  initial_coordinates[4][1][3] = 1.0 * main_length;
	polygon_matrices[4] = new Matrix_3x3();
	polygon_matrices[4].identity();
	// scale
	polygon_matrices[4].translate(0.0   , -1.0 * main_length   );
	polygon_matrices[4].rotate(1.0 * Math.PI / 3.0);
	polygon_matrices[4].translate(0.0   , 0.0 * main_length   );

	this.viewing_matrix = new Matrix_3x3();
	this.appearance_coordinates = new int[this.initial_coordinates.length][][];
	for (i = 0; i < this.appearance_coordinates.length; i++) {
	    this.appearance_coordinates[i] = new int[this.initial_coordinates[i].length][];
	    for (j = 0; j < this.appearance_coordinates[i].length; j++) {
		this.appearance_coordinates[i][j] = new int[this.initial_coordinates[i][j].length];
		for (k = 0; k < this.appearance_coordinates[i][j].length; k++) {
		    this.appearance_coordinates[i][j][k] = 0;
		}
	    }
	}

	this.offset = new double[2];
	offset[0] = x + HIDDEN_OFFSET_X;
	offset[1] = y + HIDDEN_OFFSET_Y;

	this.h = new House(scale, x, y, id + "");
    }

    public void setItUp(String s) {
	try {
	    int i;
	    String t, tl, tr;
	    int loc = 0;
	    int ml, el;
	    int k = Parser.countInstances(s, '{');
	    
	    this.hasOrders = true;

	    this.actList = new ActionList[k];
	    for (i = 0; i < this.actList.length; i++) {
		this.actList[i] = new ActionList();
	    }
	    
	    for (i = 0; i < this.actList.length; i++) {
		el = Parser.perfectClosure(s, loc, '{', '}');
		if (s.charAt(loc + 1) == '{') {
		    tl = s.substring(loc, loc + 1);
		    tr = s.substring(loc + 1, el);
		} else {
		    ml = Parser.perfectClosure(s, loc, '(', ')');
		    tl = s.substring(loc, ml);
		    tr = s.substring(ml, el);
		}
		// System.out.print("\nXXX\n");
		this.actList[i].fillActionList(tl, tr, this.pid);
		// System.out.print("\nYYY\n");
		loc = el;
	    }
	} catch (Exception e) {
	    System.out.print("This is: "+e+"\n");
	    e.printStackTrace();
	    System.out.print("\n");
	} 
    }

    public Color getColor() {
	return this.c;
    }

    public int[][][] getPersonCoordinates(int screenWidth, int screenHeight) {
	int i, j;
	double [] cord;
	this.viewing_matrix.identity();
	for (i = NUM_POLYGONS - 1; i >= 0; i--) {
	    this.viewing_matrix.copyFromMatrix(this.polygon_matrices[i]);
	    this.viewing_matrix.translate2D(offset);
	    this.viewing_matrix.mathToApplet(screenWidth, screenHeight);
	    for (j = 0; j < this.initial_coordinates[i][0].length; j++) {
		cord = this.viewing_matrix.transform(this.initial_coordinates[i][0][j], this.initial_coordinates[i][1][j]);
		this.appearance_coordinates[i][0][j] = (int)Math.round(cord[0]);
		this.appearance_coordinates[i][1][j] = (int)Math.round(cord[1]);
	    }
	}
	return this.appearance_coordinates;
    }
}
