//

import java.awt.*;

//----- ROUTINES TO DO BASIC MATRIX MATH -----

public class Matrix_3x3
{
    public static final int DIM = 3;
    
    public double[][] m;
    private double[][] temp;
    
    public Matrix_3x3() {
	m = new double[DIM][DIM];
	temp = new double[DIM][DIM];
    }

    public void identity() {
	identity(m);
    }
    
    private void identity(double[][] matrix) {
	for (int i = 0 ; i < DIM ; i++) {
	   for (int j = 0 ; j < DIM ; j++) {
	       matrix[i][j] = (i == j ? 1 : 0);
	   }
	}
    }

    private void line_matrix(double[][] matrix, double x, double y, double w) {
	identity(matrix);
	matrix[0][0] = x;
	matrix[1][0] = y;
	matrix[DIM - 1][0] = w;
	for (int i = 1 ; i < DIM ; i++) {
	    matrix[i][i] = 0;
	}
    }

    private double[][] multiply(double[][] a, double[][] b) {
	double[][] result = new double[DIM][DIM];
	for (int i = 0 ; i < DIM ; i++) {
	    for (int j = 0 ; j < DIM ; j++) {
		result[i][j] = 0;
		for (int k = 0 ; k < DIM ; k++) {
		    result[i][j] += a[i][k] * b[k][j];
		}
	    }
	}
	return result;
    }

    private void makeScaleMatrix(double x, double y) {
	identity(temp);
	temp[0][0] *= x;
	temp[1][1] *= y;
    }

    private void makeRotationMatrix(double theta) {
	identity(temp);
	temp[0][0] = temp[1][1] = Math.cos(theta);
	temp[1][0] = Math.sin(theta);
	temp[0][1] = -temp[1][0];
    }

    private void makeTranslationMatrix(double dx, double dy) {
	identity(temp);
	temp[0][DIM - 1] = dx;
	temp[1][DIM - 1] = dy;
    }

    public void scale(double x, double y) {
	makeScaleMatrix(x, y);
	m = multiply(temp, m);
    }

    public void rotate(double theta) {
	makeRotationMatrix(theta);
	m = multiply(temp, m);
    }

    public void translate(double dx, double dy) {
	makeTranslationMatrix(dx, dy);
	m = multiply(temp, m);
    }

    public void translate2D(double[] source) {
	translate(source[0], source[1]);
    }

    public double[] transform(double x, double y) {
	double[] target = new double[DIM - 1];
	line_matrix(temp, x, y, 1);
	temp = multiply(m, temp);
	target[0] = temp[0][0];
	target[1] = temp[1][0];
	return target;
    }

    public double[] transform2D(double[] source) {
	return transform(source[0], source[1]);
    }

    public void mathToApplet(int width, int height) {
	this.scale(1, -1);
	this.translate(0, height);	
    }

    public void copyFromMatrix(Matrix_3x3 that) {
	int i, j;
	for (i = 0 ; i < DIM ; i++) {
	   for (j = 0 ; j < DIM ; j++) {
	       this.m[i][j] = that.m[i][j];
	   }
	}
    }
}
