public class Letter {
    public static final int REALLY_LOW = -200;
    public static final int MESSAGE = 0;
    public static final int ACK = 1;

    // public boolean isAtOffice;
    public int personFrom;
    public int personTo;
    public int postOfficeIdUsed;
    // public int letterType;
    public int contents[][];
    /* contents[j][0] and contents[j][1] denote the msg/ack type and person/label of the jth entry in the envelope. */
    public int daysToSend;
    public boolean isSentYet;
    // public Event ev;

    public boolean hasParentsLinked;
    public boolean hasChildrenLinked;
    public int height;
    public int day;
    public int pp;
    public int cp;
    public Letter[] parents;
    public Letter[] children;
    public int lid;

    public Letter(int from, int to, int type, int days) {
	personFrom = from;
	personTo = to;
	// letterType = type;
	daysToSend = days;
    }

    public Letter(int from, int to, int poid, String[][] seq) {
	personFrom = from;
	personTo = to;
	postOfficeIdUsed = poid;
	daysToSend = 1;
	process(seq);
	isSentYet = false;
    }

    public void process(String[][] seq) {
	contents = new int[seq.length][2];
	int i;

	for (i = 0; i < seq.length; i++) {
	    if (seq[i][0].charAt(0) == 'm') {
		contents[i][0] = MESSAGE;
	    } else if (seq[i][0].charAt(0) == 'a') {
		contents[i][0] = ACK;
	    } else {
		contents[i][0] = -1;
	    }
	    contents[i][1] = Integer.parseInt(seq[i][1]);
	}
    }

    public void changeKiddieHeights() {
	int i;
	if (this.children != null) {
	    for (i = 0; i < this.children.length; i++) {
		this.children[i].height = Math.max(this.height + 1, this.children[i].height);
		this.children[i].day = this.children[i].height;
	    }
	    
	    for (i = 0; i < this.children.length; i++) {
		this.children[i].changeKiddieHeights();
	    }
	}
    }

    public void consistKiddieDays() {
	int i;
	if (this.children != null) {
	    for (i = 0; i < this.children.length; i++) {
		this.children[i].day = Math.max(this.day + this.daysToSend, this.children[i].day);
	    }
	    
	    for (i = 0; i < this.children.length; i++) {
		this.children[i].consistKiddieDays();
	    }
	}		
    }

    public void changeKiddieDays() {
	int i;
	if (this.children != null) {
	    for (i = 0; i < this.children.length; i++) {
		this.children[i].day = this.children[i].height;
	    }
	    
	    for (i = 0; i < this.children.length; i++) {
		this.children[i].changeKiddieDays();
	    }
	}	
    }

    public boolean isAncestorOf(Letter that) {
	int i;
	boolean trial;
	if ((this.height >= that.height) || (this.children == null)) {
	    return false;
	} else {
	    for (i = 0; i < this.children.length; i++) {
		if ((this.children[i] != null) && (that.lid == this.children[i].lid)) {
		    return true;
		}
	    }
	    for (i = 0; i < this.children.length; i++) {
		if (this.children[i] != null) {
		    trial = this.children[i].isAncestorOf(that);
		    if (trial) {
			return true;
		    }
		}
	    }
	    return false;
	}
    }

    public String toString() {
	StringBuffer buffy = new StringBuffer("");
	int l;
	buffy.append("Letter ID: "+this.lid+"\n");
	buffy.append("From: "+this.personFrom+"\n");
	buffy.append("To: "+this.personTo+"\n");
	buffy.append("Expected to occur on day: "+this.day+"\n");
	buffy.append("Office used: "+this.postOfficeIdUsed+"\nContents: \t");
	for (l = 0; l < this.contents.length; l++) {
	    if (this.contents[l][0] == Letter.MESSAGE) {
		buffy.append("(msg, ");
	    } else if (this.contents[l][0] == Letter.ACK) {
		buffy.append("(ack, ");
	    } else {
		buffy.append("(?, ");
	    }
	    buffy.append(this.contents[l][1]+")\t");
	}
	buffy.append("\n");
	return buffy.toString();
    }

    /* Assumes all Letters and structures are made first... */
    public static Letter[] makeLetterList(Person[] p, int n) {
	int i, j, k, l;
	int count = 0;
	int spot;
	int hspo, hspt;
	Letter[] ll;
	boolean has_cow;
	int kitty_count;
	Letter[] tempp;

	for (i = 1; i <= n; i++) {
	    for (j = 0; j < p[i].actList.length; j++) {
		for (k = 0; k < p[i].actList[j].reaction.length; k++) {
		    count++;
		}
	    }
	}

	ll = new Letter[count];
	spot = 0;
	hspo = 0;
	hspt = 0;

	for (i = 1; i <= n; i++) {
	    for (j = 0; j < p[i].actList.length; j++) {
		for (k = 0; k < p[i].actList[j].reaction.length; k++) {
		    ll[spot] = p[i].actList[j].reaction[k];
		    ll[spot].children = null;
		    ll[spot].lid = spot;
		    if ((p[i].actList[j].cause_list[0][0] == 0) && (p[i].actList[j].cause_list[0][1] == 0)) {
			ll[spot].parents = null;
			ll[spot].pp = 0;
			ll[spot].cp = 0;
			ll[spot].hasParentsLinked = true;
			ll[spot].hasChildrenLinked = false;
			// hspt++;
		    } else {
			ll[spot].parents = new Letter[p[i].actList[j].cause_list.length];
			ll[spot].pp = 0;
			ll[spot].cp = 0;
			ll[spot].hasParentsLinked = false;
			ll[spot].hasChildrenLinked = false;
		    }
		    spot++;
		}
	    }
	}

	// while (hspo < hspt) {
	    //System.out.print("New loop\n");
	    // hspo = hspt;
	    for (spot = 0; spot < ll.length; spot++) {
		// System.out.print("Hello\n");
		// System.out.print(spot+" hasParentsLinked = "+ll[spot].hasParentsLinked+
		//		 ", hasChildrenLinked = "+ll[spot].hasChildrenLinked+"\n");
		// if ((ll[spot].hasParentsLinked == true) && (ll[spot].hasChildrenLinked == false)) {
		    System.out.print("Going in with node "+spot+"\n");
		    hspt++;
		    kitty_count = 0;

		    i = ll[spot].personTo;
		    for (j = 0; j < p[i].actList.length; j++) {
			/* For each action clause, we check if we've got a cow, if so, 
			   we count up all the reaction to the cumulative total. */
			has_cow = false;
			for (k = 0; k < p[i].actList[j].cause_list.length; k++) {
			    for (l = 0; l < ll[spot].contents.length; l++) {
				if ((p[i].actList[j].cause_list[k][0] == ll[spot].contents[l][0]) && 
				    (p[i].actList[j].cause_list[k][1] == ll[spot].contents[l][1])) {
				    has_cow = true;
				}
			    }
			}

			if (has_cow) {
			    for (k = 0; k < p[i].actList[j].reaction.length; k++) {
				kitty_count++;
			    }
			}
		    }
		    if (kitty_count > 0) {
			ll[spot].children = new Letter[kitty_count];
		    } else {
			ll[spot].hasChildrenLinked = true;
		    }

		    i = ll[spot].personTo;
		    for (j = 0; j < p[i].actList.length; j++) {
			/* For each action clause, we check if we've got a cow, if so, 
			   we link all reactions as kids to this node. */
			has_cow = false;
			for (k = 0; k < p[i].actList[j].cause_list.length; k++) {
			    for (l = 0; l < ll[spot].contents.length; l++) {
				if ((p[i].actList[j].cause_list[k][0] == ll[spot].contents[l][0]) && 
				    (p[i].actList[j].cause_list[k][1] == ll[spot].contents[l][1])) {
				    has_cow = true;
				}
			    }
			}

			if (has_cow) {
			    for (k = 0; k < p[i].actList[j].reaction.length; k++) {
				ll[spot].children[ll[spot].cp] = p[i].actList[j].reaction[k];
				ll[spot].cp++;
				/*
				if (p[i].al[j].reaction[k].parents == null) {
				    p[i].al[j].reaction[k].parents = new Letter[p[i].al[j].cause_list.length];
				}
				*/
				// System.out.print("Parptr: ("+i+", "+j+", "+k+","+p[i].al[j].reaction[k].pp+")\n");
				/* CONTROVERSY */
				if (p[i].actList[j].reaction[k].pp >= p[i].actList[j].reaction[k].parents.length) {
				    tempp = new Letter[p[i].actList[j].reaction[k].parents.length + 1];
				    for (l = 0; l < p[i].actList[j].reaction[k].parents.length; l++) {
					tempp[l] = p[i].actList[j].reaction[k].parents[l];
				    }
				    p[i].actList[j].reaction[k].parents = tempp;
				}
				/* CONTROVERSY */
				p[i].actList[j].reaction[k].parents[p[i].actList[j].reaction[k].pp] = ll[spot];
				p[i].actList[j].reaction[k].pp++;
				if (ll[spot].cp >= ll[spot].children.length) {
				    ll[spot].hasChildrenLinked = true;
				}
				if (p[i].actList[j].reaction[k].pp >= p[i].actList[j].reaction[k].parents.length) {
				    p[i].actList[j].reaction[k].hasParentsLinked = true;
				}
			    }
			}
		    }
	        // }
	    }
	// }
	System.out.print("Hspt = "+hspt+", made = "+ll.length+".\n\nTime to heighten!!!\n");
	heighten(ll);
	return ll;
    }

    public static void heighten(Letter[] ll) {
	int i;
	for (i = 0; i < ll.length; i++) {
	    if (ll[i].parents == null) {
		ll[i].height = 0;
		ll[i].day = 0;
	    } else {
		ll[i].height = REALLY_LOW;
	    }
	}

	for (i = 0; i < ll.length; i++) {
	    if (ll[i].parents == null) {
		ll[i].changeKiddieHeights();
	    }
	}
    }

    public static void adjust_day(Letter[] ll) {
	int i;
	for (i = 0; i < ll.length; i++) {
	    if (ll[i].parents == null) {
		ll[i].day = ll[i].height;
	    }
	}

	for (i = 0; i < ll.length; i++) {
	    if (ll[i].parents == null) {
		ll[i].changeKiddieDays();
	    }
	}	
    }

    public static String showTree(Letter[] ll) {
	StringBuffer buffy = new StringBuffer("");
	int max_ht = REALLY_LOW;
	int i, j, h;
	for (i = 0; i < ll.length; i++) {
	    if (ll[i].height > max_ht) {
		max_ht = ll[i].height;
	    }
	}

	buffy.append("-------------Legend-----------\n");
	for (i = 0; i < ll.length; i++) {
	    buffy.append("Letter "+i+":\n"+ll[i].toString()+"\n\n");
	}

	buffy.append("\n\n---------Height Map------------\n");

	for (h = 0; h <= max_ht; h++) {
	    buffy.append("Nodes of height "+h+" are: ");
	    for (i = 0; i < ll.length; i++) {
		if (ll[i].height == h) {
		    buffy.append(i+" ");
		}
	    }
	    buffy.append("\n");
	}

	buffy.append("\n\n------------Node Parent/Kids------------\n");

	for (i = 0; i < ll.length; i++) {
	    buffy.append("Node: "+i+"\n");
	    if (ll[i].parents != null) {
		buffy.append("\tHas parents: ");
		for (j = 0; j < ll[i].parents.length; j++) {
		    if (ll[i].parents[j] != null) {
			buffy.append(ll[i].parents[j].lid+" ");
		    }
		}
		buffy.append("\n");
	    }

	    if (ll[i].children != null) {	    
		buffy.append("\tHas children: ");
		for (j = 0; j < ll[i].children.length; j++) {
		    buffy.append(ll[i].children[j].lid+" ");
		}
	    }
	    buffy.append("\n\n");
	}

	return buffy.toString();
    }

    
}
