//db_functions.h
#pragma once

#include "GraphGrepSXLibrary.h"
#include <iostream>
#include <fstream>
#include <iomanip>

#include "graph_path_finder.h"
#include "graph_search_utility.h"
#include "graph_reader.h"
#include "OCP_Tree.h"

// Build function. Require database file (txt) and
// stat_file for statistics if required

bool
db_create(const string &db_input_file, OCP_Tree* index_tree)
{
	ifstream inFile;
	inFile.open(db_input_file.c_str(), ios_base::in);
	if (!inFile.is_open())
	{
		cout << "Impossibile aprire il file di input: '" << db_input_file.c_str() << "'" << endl;
		return false;
	}

	GraphReaderStream<graph_t> gr_stream(inFile);
	graph_index_t index = 0;

	while(!inFile.eof())
	{
		if(gr_stream.ReadNextGraph())
		{
			find_all_path(gr_stream.GetGraph(),index, index_tree);
			index++;
			gr_stream.ReleaseGraph();
		}
	}
	index_tree->total_graph_count=index;

	inFile.close();
	return true;	
}


bool
db_save(const string &db_output_file, OCP_Tree* index_tree)
{
	std::ofstream os;
	os.open(db_output_file.c_str(), ios_base::binary);
	if(!os.is_open())	
		return false;
	save_label_map(os, label_map);
	index_tree->save(os);
	os.close();
	return true;
}

bool
db_load(OCP_Tree* index_tree, const string &db_iutput_file)
{
	std::ifstream is;
	is.open(db_iutput_file.c_str(), ios_base::binary|ios_base::in);
	if (!is.is_open())
		return false;
	load_label_map(is, label_map);
	index_tree->load(is);
	is.close();
	index_tree->set_child_map();
	return true;
}

bool 
db_query_load(const string & query_file, graph_t &query_graph)
{
	ifstream queryFile;
	queryFile.open(query_file.c_str(), ios_base::in);
	if (!queryFile.is_open())
	{
		cout << "Impossibile aprire il file della query: '" << query_file.c_str() << "'" << endl;
		return false;
	}

	read_graph_gg(queryFile, query_graph);
	queryFile.close();

	return true;
}

bool 
db_query_build(graph_t &query_graph, OCP_Tree* q_index_tree)
{
	find_one_path(query_graph,0, q_index_tree);
	q_index_tree->clear_single_firstlevel_node();
	//q_index_tree->refind_special();
	//q_index_tree->special_count();

	return true;
}

void 
db_query_run(OCP_Tree* index_tree, OCP_Tree* q_index_tree, graph_set_t &set)
{
	index_tree->match(q_index_tree, set);
}

bool
db_query_out(graph_set_t &set)
{
	string output_candidates_file = "candidates.txt";
	string vento_ts_file;

#ifdef WIN32 // definita nelle direttive del preprocessore in Visual Studio 7.0
	vento_ts_file = "graphblastdata\\translate.dat";
#else // sotto linux
	vento_ts_file = ".//graphblastdata//translate.dat";
#endif

	ofstream out_candidatesFile;
	out_candidatesFile.open(output_candidates_file.c_str(), ios_base::out);
	if (!out_candidatesFile.is_open())
	{
		cout << "Impossibile salvare il file di output dei candidati: '" << output_candidates_file.c_str() << "'" << endl;
		return false;
	}

	for(graph_set_t::iterator it = set.begin(); it!=set.end(); it++)
		out_candidatesFile<<*it<<endl;
	out_candidatesFile.close();

	ofstream out_translateFile;
	out_translateFile.open(vento_ts_file.c_str(), ios_base::out);
	if (!out_translateFile.is_open())
	{
		cout << "Impossibile salvare il file translate.dat per vento: '" << vento_ts_file.c_str() << "'" << endl;
		return false;
	}

	graph_index_t db_index = 0; graph_index_t vento_index = 0;
	graph_set_t::iterator g_it = set.begin();
	while(g_it!=set.end())
	{
		if(*g_it==db_index)
		{
			out_translateFile<<vento_index<<' '<<db_index<<endl;
			g_it++;;
			vento_index++;
		}

		db_index++;
	}

	return true;
}

double get_vento_time()
{
	string vento_db_out_file = "vento_mt_out.txt";
	ifstream Vento_inFile;
	Vento_inFile.open(vento_db_out_file.c_str(), ios_base::in);
	if (!Vento_inFile.is_open())
	{
		return -1;
	}

	string out_str; // #Matching_time: %.2lf\n
	Vento_inFile >> out_str; //dummy remove #Matching_time: string
	Vento_inFile >> out_str;

	Vento_inFile.close();

	double mt = stringto<double>(out_str);
	return mt;
}

void vento_run(const string &query_file)
{
	string vento_db_file = "vento_db.txt";
	string vento_db_out_file = "vento_mt_out.txt";

#ifdef WIN32 // definita nelle direttive del preprocessore in Visual Studio 7.0
	string cmd = "Vento.exe " + vento_db_file + " " +  query_file + " > " + vento_db_out_file;
	system(cmd.c_str());
#else // sotto linux
	string cmd = "./Vento " + vento_db_file + " " +  query_file + " > " + vento_db_out_file;
	system(cmd.c_str());
#endif

	return;
}

bool
db_filter(const string &input_network_file, graph_set_t &set)
{
	string vento_db_file = "vento_db.txt";
	return to_vento_db(input_network_file, vento_db_file, set);
}

bool
db_filter_by_cache(db_cache &cache, graph_set_t &set)
{
	return cache.select(set, "vento_db.txt");
}

int  db_add_next(GraphReaderStream<graph_t> &gr_stream, OCP_Tree* index_tree, graph_index_t index){
	if(gr_stream.ReadNextGraph()){
		find_all_path(gr_stream.GetGraph(),index, index_tree);
		gr_stream.ReleaseGraph();
		index++;
		index_tree->total_graph_count=index;
		return index;
	}
	return -1;
}

