#ifndef _STRUCTKMEANS
#define _STRUCTKMEANS

#include "constants.h"

typedef struct OBJECT{
  int *index;
  float *X; 
  int *idx_CLU;
  float *Dv;
  float Dc;
  int   dvS;
  float Do;
  int clu;
}Object;



/*
  Cluster is the data structure which contains the information of the clustering created by
  using the Kmeans algorithm
*/

typedef struct CLUSTER{
  int *Elements;
  float *Dc;
  int Centroid;
  float radius;
  int   size;
  struct CLUSTER *next;
}Cluster;

int n;                 // number of data graphs
int SpaceDim;          // number of substructures
Object *S;             // Elements of the Kmeans
char choice;           // 'I' for inner product and 'E' for Euclidean distance

Cluster *G;            // Kmeans data structures

int **MAPPA;           // It cointans the n Spacedim vectors
char **words;          // substructures generated with AllPairShortestPath
int **len_words;       // length of label substructures
int cont_words;        // number of substructures 
int *loc_con;          // progressive number of substructures for each data graph

char directed;         // 'd' for directed graphs, 'u' for undirected graphs

#endif
