#include "printAntipole.h"



/*
  It takes the Antipole structure, and an integer and
  returns the number of clusters generated
*/

void visualizza(W_Tree *T,int *num_clusters) {
  if(!T)
    return;
  if(T->leaf==TRUE) {
    (*num_clusters)++;
  }
  else {
    visualizza(T->left,num_clusters);
    visualizza(T->right,num_clusters);
  }
}



/*
  It takes the Antipole structure, the names of the input graphs, the number
  of clusters and a file descriptor *fp and
  writes the output in *fp
*/

void write_output(W_Tree *T,char **name,int *num_clusters,FILE *fp) {
  int i;
  if(!T)
    return;
  if(T->leaf==TRUE) {
    if(T->Size > 2) {
      fprintf(fp,"CLUSTER %d [size:%d radius:%f]\n     Centroid : '%s'\n",*num_clusters,T->Size,T->clust->radius,name[*T->clust->Centroid->index]);
      for(i=0;i<T->clust->size;i++) {
	fprintf(fp,"     Element  : '%s' [Dc:%f]\n",name[*T->clust->Elements[i].index],T->clust->Elements[i].Dc);
      }
      fprintf(fp,"\n");
    }
    else
      if(T->Size == 2) {
	fprintf(fp,"CLUSTER %d [size:%d radius:%f]\n     Centroid : '%s'\n",*num_clusters,T->Size,T->Dab,name[*T->A->index]);
	fprintf(fp,"     Element  : '%s' [Dc:%f]\n",name[*T->B->index],T->Dab);
	fprintf(fp,"\n");
      }
      else {
	if(T->Size == 1) {
	  fprintf(fp,"CLUSTER %d [size:%d radius:%f]\n     Centroid : '%s'\n",*num_clusters,T->Size,T->clust->radius,name[*T->A->index]);
	  fprintf(fp,"\n");
	}
      }
    (*num_clusters)++;
  }
  else {
    write_output(T->left,name,num_clusters,fp);
    write_output(T->right,name,num_clusters,fp);
  }
}
