#include "parser.h"



/*
  It return the right element for the PriorityQueue
*/

int Right_Parser(int x,PriorityQueue *PQ) {
  if(2*x+1 <= PQ->heapsize)
    return 2*x+1;
  else
    return x;
}



/*
  It return the left element for the PriorityQueue
*/

int Left_Parser(int x,PriorityQueue *PQ) {
  if(2*x <= PQ->heapsize)
    return 2*x;
  else
    return x;
}



/*
  It return the parent element for the PriorityQueue
*/

int Parent_Parser(int x) {
  return floor((float)(((float)(x))/2));
}



/*
  Function to insert elements into PriorityQueue
*/

void Insert_Parser(PriorityQueue **PQ,int key,int idx) {
  int i,tmp;
  (*PQ)->heapsize++;
  i =  (*PQ)->heapsize;
  (*PQ)->dist = (Obj *)realloc((*PQ)->dist,sizeof(Obj)*(i+1));
  if((*PQ)->dist==NULL) {
    exit(-1);
  }
  (*PQ)->dist[i].key = key;
  (*PQ)->dist[i].idx = idx;
  while(i > 1 && ((*PQ)->dist[Parent_Parser(i)].key < (*PQ)->dist[i].key)) {
    tmp = (*PQ)->dist[Parent_Parser(i)].key;
    (*PQ)->dist[Parent_Parser(i)].key = (*PQ)->dist[i].key;
    (*PQ)->dist[i].key = tmp;
    tmp = (*PQ)->dist[Parent_Parser(i)].idx;
    (*PQ)->dist[Parent_Parser(i)].idx = (*PQ)->dist[i].idx;
    (*PQ)->dist[i].idx = tmp;
    i = Parent_Parser(i);
  }
}



/*
  Function to order the PriorityQueue
*/

void Heapify_Parser(PriorityQueue **PQ,int i) {
  int largest,tmp;
  if((*PQ)->dist[i].key > (*PQ)->dist[Left_Parser(i,(*PQ))].key) {
    if((*PQ)->dist[i].key > (*PQ)->dist[Right_Parser(i,(*PQ))].key)
      largest = i;
    else
      largest = Right_Parser(i,(*PQ));
  }
  else
    if((*PQ)->dist[Left_Parser(i,(*PQ))].key > (*PQ)->dist[Right_Parser(i,(*PQ))].key)
      largest = Left_Parser(i,(*PQ));
    else
      largest = Right_Parser(i,(*PQ));
  if(largest != i) {
    tmp = (*PQ)->dist[i].key;
    (*PQ)->dist[i].key = (*PQ)->dist[largest].key;
    (*PQ)->dist[largest].key = tmp;
    tmp = (*PQ)->dist[i].idx;
    (*PQ)->dist[i].idx = (*PQ)->dist[largest].idx;
    (*PQ)->dist[largest].idx = tmp;
    Heapify_Parser(PQ,largest);
  }
}



/*
  Function to retrieve elements from the PriorityQueue
*/

int Dequeue_Parser(PriorityQueue **PQ) {
  int ret;
  ret = (*PQ)->dist[1].idx;
  (*PQ)->dist[1].key = (*PQ)->dist[(*PQ)->heapsize].key;
  (*PQ)->dist[1].idx = (*PQ)->dist[(*PQ)->heapsize].idx;
  ((*PQ)->heapsize)--;
  Heapify_Parser(PQ,1);
  return ret;
}



/*
  It runs AllPairShortestPath algorithm to find the substructures
*/

void AllPairShortestPath(int n,int *Adj[],int *cont,int ***pred,int ***Dis) {
  int i,tmp,u,j;
  PriorityQueue *PQ=NULL;

  *pred = (int **)malloc(n*sizeof(int *));
  *Dis = (int **)malloc(n*sizeof(int *));
  for(i=0;i<n;i++) {
    (*pred)[i] = (int *)malloc(n*sizeof(int));
    (*Dis)[i] = (int *)malloc(n*sizeof(int));
  }
  for(j=0;j<n;j++) {
    memset((*pred)[j],-1,sizeof(int)*n);
    for(i=0;i<n;i++) {
      (*Dis)[j][i] = INFINITY;
      (*pred)[i][i]=0;
    }

    (*Dis)[j][j] = 0;
    PQ = (PriorityQueue *)malloc(sizeof(PriorityQueue));
    PQ->dist = (Obj *)malloc(sizeof(Obj)*n);
    PQ->heapsize = 0;
    Insert_Parser(&PQ,-(*Dis)[j][j],j);
    while(PQ->heapsize > 0) {
      u = Dequeue_Parser(&PQ);
      for(i=0;i<cont[u];i++)
        if((*Dis)[j][Adj[u][i]] > (*Dis)[j][u] + 1) {
          tmp = (*Dis)[j][Adj[u][i]];
          (*Dis)[j][Adj[u][i]] = (*Dis)[j][u] + 1;
	  (*pred)[j][Adj[u][i]] = u;
	  if(tmp == INFINITY) {
	    Insert_Parser(&PQ,-(*Dis)[j][Adj[u][i]],Adj[u][i]);
          }
        }
    }
    free(PQ->dist);
    free(PQ);
  }
}



/*
  It computes all the paths up to the LP value by using AllPairShortestPath and creates the main matrix
  substructures - graphs (only if AllPairShortestPath is used)
*/

void Visual_Parser(int start,int i,int num,char **types,int **pred,int num_grafo) {
  int j,m,c,l,flag,siz,cont,flag1,cont_j,jj,kk;
  int *temp_cont_j;
  char **str=NULL;
  char *stringa=NULL;
  char *stringa_rev=NULL;

  temp_cont_j = (int *)malloc(sizeof(int)*1000);
  
  for(j=0;j<num;j++) {
    flag1 = FALSE;
    m = j;
    c = 0;
    str = (char **)realloc(str,sizeof(char *)*(c+1));
    str[c] = types[m];
    if(m!=start)
      do {
	m = pred[start][m];
	if(m==-1) {
	  flag1 = TRUE;
	  break;
	}
	c++;
	str = (char **)realloc(str,sizeof(char *)*(c+1));
	str[c] = types[m];
	if(c >= LP)
	  break;
      }
      while(m!=start);

    if(flag1 == TRUE)
      continue;

    if(c<=LP-1) {
      stringa = NULL;
      cont_j=0;
      for(m=c;m>=0;m--) {
	if(stringa!=NULL) {
	  siz = strlen(stringa);
	  stringa = (char *)realloc(stringa,sizeof(char)*(siz+strlen(str[m])+1));
	  stringa[siz+strlen(str[m])] = '\0';
	}
	else {
	  stringa = (char *)realloc(stringa,sizeof(char)*(strlen(str[m])+1));
	  strcpy(stringa,"");
	}
	temp_cont_j[cont_j++]=strlen(str[m]);
	strcat(stringa,str[m]);
      }
      stringa_rev = NULL;
      cont = 0;
      stringa_rev = (char *)malloc(sizeof(char)*(strlen(stringa)+1));
      kk=cont_j-1;
      for(l=strlen(stringa)-1;l>=0;l--) {
	
	for(jj=l-temp_cont_j[kk]+1;jj<=l;jj++) {
	  stringa_rev[cont++] = stringa[jj];
	}
	l-=temp_cont_j[kk]-1;
	kk--;
      }
      stringa_rev[cont] = '\0';
      
      flag = FALSE;
      for(l=0;l<cont_words;l++)
	if(!strcmp(words[l],stringa) || (directed=='u' && !strcmp(words[l],stringa_rev))) {
	  MAPPA[num_grafo][l]++;
	  flag = TRUE;
      	  break;
      	}
      if(flag == FALSE) { // word still doesn't exist for graphs visit
	cont_words++;
	words = (char **)realloc(words,sizeof(char *)*cont_words);
	words[cont_words-1] = stringa;
	len_words = (int **)realloc(len_words,sizeof(int *)*cont_words);
	len_words[cont_words-1] = NULL;
	len_words[cont_words-1] = (int *)realloc(len_words[cont_words-1],sizeof(int)*cont_j);
	for(jj=0;jj<cont_j;jj++) {
	  len_words[cont_words-1][jj] = temp_cont_j[jj];
	}
	MAPPA[num_grafo] = (int *)realloc(MAPPA[num_grafo],sizeof(int)*cont_words);
	MAPPA[num_grafo][cont_words-1] = 1;
	loc_con = (int *)realloc(loc_con,sizeof(int)*(num_grafo+1));
	loc_con[num_grafo] = cont_words;
      }
      else {
	free(stringa);
	stringa = NULL;
      }
      free(stringa_rev);
      stringa_rev=NULL;
    }
  }
  free(temp_cont_j);
  free(str);
}



/*
  It takes the file pointer to the data and reads the data graphs, saving their names in *name,
  their number in num_grafo and writes in MAPPA the substructures found with AllPairShortestPath
*/

void ParserAllPairShortestPath(FILE *fp,char ***name,int *num_grafo) {
  char str[MAX_SIZE_LABEL];
  char **types=NULL;
  int *cont,**adj,**pred=NULL,**Dis=NULL;
  int i,j,num,num_edge,e1,e2;

  assert(fp);
  while(!feof(fp)) {
    fscanf(fp,"%s",str);
    if(feof(fp))
      break;
    if(str[0]=='#') { // New graph
      if(strlen(str)>=MAX_SIZE_LABEL) {
	fprintf(stderr,"\n   --ERROR-- Graph labels too big!!!\n\n");
	exit(-1);
      }
      *name = (char **)realloc(*name,sizeof(char *)*((*num_grafo)+1));
      (*name)[*num_grafo] = (char *)malloc(sizeof(char)*(strlen(str)+1));
      strcpy((*name)[*num_grafo],str);
      fscanf(fp,"%d",&num);
      cont = (int *)malloc(sizeof(int)*num);
      adj = (int **)malloc(sizeof(int *)*num);
      for(i=0;i<num;i++) {
	adj[i] = NULL;
	cont[i] = 0;
	types = (char **)realloc(types,sizeof(char *)*(i+1));
	fscanf(fp,"%s",str);
	if(strlen(str) >= MAX_SIZE_LABEL) {
	  fprintf(stderr,"\n    --ERROR-- Node labels too long!!!\n\n");
	  exit(-1);
	}
	types[i] = NULL;
	types[i] = (char *)realloc(types[i],sizeof(char)*(strlen(str)+1));
	strcpy(types[i],str);
      }
      fscanf(fp,"%d",&num_edge);

      for(i=0;i<num_edge;i++) {
	fscanf(fp,"%d %d",&e1,&e2);
	adj[e1] = (int *)realloc(adj[e1],sizeof(int)*(cont[e1]+1));
	adj[e1][cont[e1]] = e2;
	cont[e1]++;
	if(directed=='u') {
	  adj[e2] = (int *)realloc(adj[e2],sizeof(int)*(cont[e2]+1));
	  adj[e2][cont[e2]] = e1;
	  cont[e2]++;
	}
      }

      AllPairShortestPath(num,adj,cont,&pred,&Dis);
      MAPPA = (int **)realloc(MAPPA,sizeof(int *)*((*num_grafo)+1));
      MAPPA[*num_grafo] = NULL;
      if(cont_words > 0)
	MAPPA[*num_grafo] = (int *)realloc(MAPPA[*num_grafo],sizeof(int)*cont_words);
      loc_con = (int *)realloc(loc_con,sizeof(int)*((*num_grafo)+1));
      loc_con[*num_grafo] = cont_words;
      
      for(j=0;j<cont_words;j++)
	MAPPA[*num_grafo][j] = 0;

      for(i=0;i<num;i++) {
	Visual_Parser(i,i,num,types,pred,*num_grafo);
      }
      for(i=0;i<num;i++) {
      	free(pred[i]);
	free(types[i]);
	if(adj[i]!=NULL)
	  free(adj[i]);
      }
      free(types);
      free(adj);
      adj = NULL;
      types = NULL;
      free(pred);
      pred = NULL;
      for(i=0;i<num;i++)
      	free(Dis[i]);
      free(Dis);
      Dis = NULL;
      (*num_grafo)++;
      free(cont);
      cont = NULL;
    }
  }
  fclose(fp);
  return;
}



/*
  It takes the file pointer to the data and reads the data graphs, saving their names in *name,
  their number in num_grafo and writes in Mat the substructures found with Subdue with size in *size
*/

void ParserSubdue(FILE *fp,int *num_grafo,char ***name,int **size,int ***Mat) {
  FILE *fp1=NULL,*f1=NULL,*f2=NULL;
  char str[MAX_SIZE_LABEL],nnn[MAX_STR],nnn1[MAX_STR],com[MAX_STR],c;
  int num,num_edge,e1,e2,i,j,k,*bool=NULL;

  assert(fp);
  system("rm -rf subdue_files");
  system("mkdir subdue_files");
  while(!feof(fp)) {
    fscanf(fp,"%s",str);
    if(feof(fp))
      break;
    if(str[0]=='#') { // New graph
      if(strlen(str)>=MAX_SIZE_LABEL) {
	fprintf(stderr,"\n   --ERROR-- Graph labels too big!!!\n\n");
	exit(-1);
      }
      
      num = num_edge = 0;
      sprintf(nnn,"subdue_files/%d",*num_grafo);
      fp1 = fopen(nnn,"w");
      assert(fp1);
      *name = (char **)realloc(*name,sizeof(char *)*((*num_grafo)+1));
      (*name)[*num_grafo] = (char *)malloc(sizeof(char)*(strlen(str)+1));
      strcpy((*name)[*num_grafo],str);
      fscanf(fp,"%d",&num);
      for(i=0;i<num;i++) {
	fscanf(fp,"%s",str);
	if(strlen(str)>=MAX_SIZE_LABEL) {
	  fprintf(stderr,"\n    --ERROR-- Node labels too long!!!\n\n");
	  exit(-1);
	}
	fprintf(fp1,"v %d %s\n",i+1,str);
      }
      fscanf(fp,"%d",&num_edge);
      for(i=0;i<num_edge;i++) {
	fscanf(fp,"%d %d",&e1,&e2);
	fprintf(fp1,"%c %d %d A\n",directed,e1+1,e2+1);
      }
      fclose(fp1);

      strcpy(com,"./subdue -out ./subdue_files/");
      sprintf(nnn,"%d",*num_grafo);
      strcat(com,nnn);
      strcat(com,".sub ");
      if(directed == 'u')
        strcat(com," -undirected ");
      strcat(com," -maxsize 10 ./subdue_files/");
      strcat(com,nnn);
      strcat(com," > /dev/null");
      system(com);
      strcat(nnn,".sub");
      sprintf(com,"./subdue_files/");
      strcat(com,nnn);
      f1 = fopen(com,"r+");
      fscanf(f1,"%s",str);
      bool = (int *)realloc(bool,sizeof(int)*(*num_grafo+1));
      if(!strcmp(str,"S")) {
	cont_words++;
	bool[*num_grafo] = 1;
	fseek(f1,0,0);
	fprintf(f1," ");
	num=0;
	while(!feof(f1)) {
	  fscanf(f1,"%c",&c);
	  switch(c) {
	  case 'v':
	    num++;
	    fscanf(f1,"%d %c",&e1,&c);
	    break;
	  case 'u':
	  case 'd':
	    break;
	  }
	}
	*size = (int *)realloc((*size),sizeof(int)*(*num_grafo+1));
	(*size)[*num_grafo]=num;
      }
      else
	bool[*num_grafo] = 0;
      fclose(f1);
      (*num_grafo)++;
    }
  }
  
  *Mat = (int **)malloc(sizeof(int *)*(*num_grafo));
  for(i=0;i<(*num_grafo);i++)
    (*Mat)[i] = (int *)malloc(sizeof(int)*cont_words);
  for(i=0;i<(*num_grafo);i++) {
    for(j=0;j<cont_words;j++) {
      (*Mat)[i][j] = 0;
    }
  }
  
  k = 0;
  for(i=0;i<(*num_grafo);i++) {
    if(bool[i]==TRUE) {
      sprintf(nnn,"./subdue_files/%d",i);
      strcat(nnn,".sub");
      for(j=0;j<(*num_grafo);j++) {
	sprintf(nnn1,"./subdue_files/%d",j);
	strcpy(com,"./sgiso ");
	strcat(com,nnn);
	strcat(com," ");
	strcat(com,nnn1);
	strcat(com," > out_subdue");
	system(com);
	f2 = fopen("out_subdue","r");
	num = 0;
	while(!feof(f2)) {
	  fscanf(f2,"%s",str);
	  if(!strcmp(str,"Found")) {
	    fscanf(f2,"%d",&num);
	    break;
	  }
	}
	(*Mat)[j][k] = num;
	fclose(f2);
      }
      k++;
    }
  }
  free(bool);
  fclose(fp);
  return;
}
