import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;
import java.lang.Object.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;

class grafo extends JPanel {
    
    public void paintComponent(Graphics g) {
	super.paintComponent(g);
	g.drawOval(10,10,170,170);
    }
    
}

class ListGraphs extends JList {

    JScrollPane s1,s2;
    String path;
    
    void Change() {
	String str1 = new String((String)getSelectedValue());
	str1 = str1.substring(0,str1.indexOf(" "));
	str1 = str1.concat(".png");

	String str2 = new String((String)getSelectedValue());
	str2 = str2.substring(str2.indexOf(" ")+1,str2.lastIndexOf(" "));
	str2 = str2.concat(".png");
	
	ImageIcon i1 = new ImageIcon(path+str1);
	ImageIcon i2 = new ImageIcon(path+str2);

	JLabel label1 = new JLabel( i1 );
	JLabel label2 = new JLabel( i2 );

	if(i1.getImageLoadStatus()==MediaTracker.ERRORED) {
	    i1 = new ImageIcon("img/error.png");
	    label1 = new JLabel( i1 );
	}
	if(i2.getImageLoadStatus()==MediaTracker.ERRORED) {
	    i2 = new ImageIcon("img/error.png");
	    label2 = new JLabel( i2 );
	}
	
	s1.getViewport().add(label1);
	s2.getViewport().add(label2);

    }

    public ListGraphs (ArrayList ar,JScrollPane ss1, JScrollPane ss2,String pathfile) {
	
	super(ar.toArray());
	
	s1 = ss1;
	s2 = ss2;
	path = pathfile;

	setSelectedIndex(0);
	Change();

	addListSelectionListener(new ListSelectionListener() {
		public void valueChanged(ListSelectionEvent event) {
		    
		    if (((JList)event.getSource()).getSelectedIndex() >= 0) {
			Change();
		    }
		}
	    });
	
	setSelectionBackground(Color.BLUE);
	setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    }
}

public class graphs extends JFrame{

    JScrollPane scrollPane,scrollPane1,scroll;
    ListGraphs listbox;
    ArrayList ar = new ArrayList();
    String pathdir;
    
    public void Load(String pathfile) {
	try {
	    int next=0;
	    char nextc;
	    BufferedReader file = new BufferedReader(new FileReader(pathfile));
	    String nextStr;
	    nextStr = file.readLine();
	    if(nextStr==null) {
		System.out.println("No substructures selected");
		System.exit(0);
	    }
	    while(nextStr!=null) {
		String t1 = nextStr.substring(1,nextStr.lastIndexOf('S'));
		String t2 = nextStr.substring(nextStr.lastIndexOf('S')+1,nextStr.lastIndexOf(' '));
		String str2 = new String("Graph");
		String cor = new String(nextStr.substring(nextStr.lastIndexOf(' ')+1,nextStr.length()));
		
		ar.add(next++,new String(str2 + t1 + str2 + t2 + " " + cor));
		
		nextStr = file.readLine();
	    }
	    file.close();
	}
	catch(IOException e) {
	    System.out.println("Error!!!");
	}
    }
       
    public graphs(String pathfile) {
	super("GraphClust: Correlated Substructures Pairs");
	setSize(800,600);
	Toolkit tk = Toolkit.getDefaultToolkit();
	Image img = tk.getImage("img/main.gif");
	setIconImage(img);
	addWindowListener(new WindowAdapter() {
		public void windowClosing(WindowEvent e) {
		    System.exit(0);
		}
	  }
	);
	
	JPanel p = new JPanel();
	p.setLayout(new BorderLayout());
	getContentPane().add(p);
	Load(pathfile);
	
	scroll = new JScrollPane();
	scrollPane = new JScrollPane();
	scrollPane1 = new JScrollPane();

	pathdir = pathfile.substring(0,pathfile.lastIndexOf('/')+1);

	listbox = new ListGraphs(ar,scrollPane,scrollPane1,pathdir);
	scroll.getViewport().add(listbox);
	
	p.add(scroll,BorderLayout.WEST);	
	JPanel pp = new JPanel(new GridLayout(1,2));
	pp.add(scrollPane);
	pp.add(scrollPane1);

	p.add(pp,BorderLayout.CENTER);
    }
}
