/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.IOException;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.ArchiveScanner;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.TarResource;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;

public class TarScanner
extends ArchiveScanner {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void fillMapsFromArchive(Resource src, String encoding, Map fileEntries, Map matchFileEntries, Map dirEntries, Map matchDirEntries) {
        TarEntry entry = null;
        TarInputStream ti = null;
        try {
            try {
                try {
                    ti = new TarInputStream(src.getInputStream());
                }
                catch (IOException ex) {
                    throw new BuildException("problem opening " + this.srcFile, ex);
                }
            }
            catch (IOException ex) {
                throw new BuildException("problem reading " + this.srcFile, ex);
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            if (ti == null) throw throwable;
            try {
                ti.close();
                throw throwable;
            }
            catch (IOException ex) {
                // empty catch block
            }
            throw throwable;
        }
        while ((entry = ti.getNextEntry()) != null) {
            TarResource r = new TarResource(src, entry);
            String name = entry.getName();
            if (entry.isDirectory()) {
                name = TarScanner.trimSeparator(name);
                dirEntries.put(name, r);
                if (!this.match(name)) continue;
                matchDirEntries.put(name, r);
                continue;
            }
            fileEntries.put(name, r);
            if (!this.match(name)) continue;
            matchFileEntries.put(name, r);
        }
        Object var12_13 = null;
        if (ti == null) return;
        try {}
        catch (IOException ex) {
            return;
        }
        ti.close();
    }
}

