/*
 * Decompiled with CFR 0.152.
 */
package interfascia;

import interfascia.GUIComponent;
import interfascia.GUIEvent;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class IFTextField
extends GUIComponent {
    private int currentColor;
    private String contents = "";
    private int cursorPos = 0;
    private int visiblePortionStart = 0;
    private int visiblePortionEnd = 0;
    private int startSelect = -1;
    private int endSelect = -1;
    private float contentWidth = 0.0f;
    private float visiblePortionWidth = 0.0f;
    private float cursorXPos = 0.0f;
    private float startSelectXPos = 0.0f;
    private float endSelectXPos = 0.0f;

    public IFTextField(String newLabel, int newX, int newY) {
        this(newLabel, newX, newY, 100, "");
    }

    public IFTextField(String argLabel, int argX, int argY, int argWidth) {
        this(argLabel, argX, argY, argWidth, "");
    }

    public IFTextField(String argLabel, int argX, int argY, int argWidth, String newValue) {
        this.setLabel(argLabel);
        this.setPosition(argX, argY);
        this.setSize(argWidth, 21);
        this.setValue(newValue);
    }

    public static boolean validUnicode(char b) {
        char c = b;
        return c >= ' ' && c <= '~' || c >= '\u00a1' && c <= '\u017f' || c == '\u018f' || c == '\u0192' || c >= '\u01a0' && c <= '\u01a1' || c >= '\u01af' && c <= '\u01b0' || c >= '\u01d0' && c <= '\u01dc' || c >= '\u01fa' && c <= '\u01ff' || c >= '\u0218' && c <= '\u021b' || c >= '\u0250' && c <= '\u02a8' || c >= '\u02b0' && c <= '\u02e9' || c >= '\u0300' && c <= '\u0345' || c >= '\u0374' && c <= '\u0375' || c == '\u037a' || c == '\u037e' || c >= '\u0384' && c <= '\u038a' || c >= '\u038e' && c <= '\u03a1' || c >= '\u03a3' && c <= '\u03ce' || c >= '\u03d0' && c <= '\u03d6' || c >= '\u03da' || c >= '\u03dc' || c >= '\u03de' || c >= '\u03e0' || c >= '\u03e2' && c <= '\u03f3' || c >= '\u0401' && c <= '\u044f' || c >= '\u0451' && c <= '\u045c' || c >= '\u045e' && c <= '\u0486' || c >= '\u0490' && c <= '\u04c4' || c >= '\u04c7' && c <= '\u04c9' || c >= '\u04cb' && c <= '\u04cc' || c >= '\u04d0' && c <= '\u04eb' || c >= '\u04ee' && c <= '\u04f5' || c >= '\u04f8' && c <= '\u04f9' || c >= '\u0591' && c <= '\u05a1' || c >= '\u05a3' && c <= '\u05c4' || c >= '\u05d0' && c <= '\u05ea' || c >= '\u05f0' && c <= '\u05f4' || c >= '\u060c' || c >= '\u061b' || c >= '\u061f' || c >= '\u0621' && c <= '\u063a' || c >= '\u0640' && c <= '\u0655' || c >= '\u0660' && c <= '\u06ee' || c >= '\u06f0' && c <= '\u06fe' || c >= '\u0901' && c <= '\u0939' || c >= '\u093c' && c <= '\u094d' || c >= '\u0950' && c <= '\u0954' || c >= '\u0958' && c <= '\u0970' || c >= '\u0e01' && c <= '\u0e3a' || c >= '\u1e80' && c <= '\u1e85' || c >= '\u1ea0' && c <= '\u1ef9' || c >= '\u2000' && c <= '\u202e' || c >= '\u2030' && c <= '\u2046' || c == '\u2070' || c >= '\u2074' && c <= '\u208e' || c == '\u2091' || c >= '\u20a0' && c <= '\u20ac' || c >= '\u2100' && c <= '\u2138' || c >= '\u2153' && c <= '\u2182' || c >= '\u2190' && c <= '\u21ea' || c >= '\u2190' && c <= '\u21ea' || c >= '\u2000' && c <= '\u22f1' || c == '\u2302' || c >= '\u2320' && c <= '\u2321' || c >= '\u2460' && c <= '\u2469' || c == '\u2500' || c == '\u2502' || c == '\u250c' || c == '\u2510' || c == '\u2514' || c == '\u2518' || c == '\u251c' || c == '\u2524' || c == '\u252c' || c == '\u2534' || c == '\u253c' || c >= '\u2550' && c <= '\u256c' || c == '\u2580' || c == '\u2584' || c == '\u2588' || c == '\u258c' || c >= '\u2590' && c <= '\u2593' || c == '\u25a0' || c >= '\u25aa' && c <= '\u25ac' || c == '\u25b2' || c == '\u25ba' || c == '\u25bc' || c == '\u25c4' || c == '\u25c6' || c >= '\u25ca' && c <= '\u25cc' || c == '\u25cf' || c >= '\u25d7' && c <= '\u25d9' || c == '\u25e6' || c == '\u2605' || c == '\u260e' || c == '\u261b' || c == '\u261e' || c >= '\u263a' && c <= '\u263c' || c == '\u2640' || c == '\u2642' || c == '\u2660' || c == '\u2663' || c == '\u2665' || c == '\u2666' || c == '\u266a' || c == '\u266b' || c >= '\u2701' && c <= '\u2709' || c >= '\u270c' && c <= '\u2727' || c >= '\u2729' && c <= '\u274b' || c == '\u274d' || c >= '\u274f' && c <= '\u2752' || c == '\u2756' || c >= '\u2758' && c <= '\u275e' || c >= '\u2761' && c <= '\u2767' || c >= '\u2776' && c <= '\u2794' || c >= '\u2798' && c <= '\u27be' || c >= '\uf001' && c <= '\uf002' || c >= '\uf021' && c <= '\uf0ff' || c >= '\uf601' && c <= '\uf605' || c >= '\uf610' && c <= '\uf616' || c >= '\uf800' && c <= '\uf807' || c >= '\uf80a' && c <= '\uf80b' || c >= '\uf80e' && c <= '\uf811' || c >= '\uf814' && c <= '\uf815' || c >= '\uf81f' && c <= '\uf820' || c >= '\uf81f' && c <= '\uf820' || c == '\uf833';
    }

    public void initWithParent() {
        this.controller.parent.registerMouseEvent(this);
    }

    private void addChar(char c) {
        String t2;
        String t1;
        if (this.startSelect != -1 && this.endSelect != -1) {
            if (this.startSelect > this.endSelect) {
                int temp = this.startSelect;
                this.startSelect = this.endSelect;
                this.endSelect = temp;
            }
            if (this.endSelect > this.contents.length()) {
                this.endSelect = this.contents.length();
            }
            t1 = this.contents.substring(0, this.startSelect);
            t2 = this.contents.substring(this.endSelect);
            this.cursorPos = this.startSelect;
            this.endSelect = -1;
            this.startSelect = -1;
        } else {
            t1 = this.contents.substring(0, this.cursorPos);
            t2 = this.contents.substring(this.cursorPos);
        }
        this.contents = String.valueOf(t1) + c + t2;
        ++this.cursorPos;
        if (this.controller.parent.textWidth(this.contents) < (float)(this.getWidth() - 12)) {
            this.visiblePortionStart = 0;
            this.visiblePortionEnd = this.contents.length();
        } else if (this.cursorPos == this.contents.length()) {
            this.visiblePortionEnd = this.cursorPos;
            this.shrinkLeft();
        } else if (this.cursorPos >= this.visiblePortionEnd) {
            this.centerCursor();
        } else {
            this.visiblePortionEnd = this.visiblePortionStart;
            this.growRight();
        }
        this.fireEventNotification(this, "Modified");
    }

    private void backspaceChar() {
        String t1 = "";
        String t2 = "";
        if (this.startSelect != -1 && this.endSelect != -1) {
            if (this.startSelect > this.endSelect) {
                int temp = this.startSelect;
                this.startSelect = this.endSelect;
                this.endSelect = temp;
            }
            if (this.endSelect > this.contents.length()) {
                this.endSelect = this.contents.length();
            }
            t1 = this.contents.substring(0, this.startSelect);
            t2 = this.contents.substring(this.endSelect);
            this.cursorPos = this.startSelect;
            this.endSelect = -1;
            this.startSelect = -1;
            this.contents = String.valueOf(t1) + t2;
        } else if (this.cursorPos > 0) {
            if (this.cursorPos > this.contents.length()) {
                this.cursorPos = this.contents.length();
            }
            t1 = this.contents.substring(0, this.cursorPos - 1);
            t2 = this.contents.substring(this.cursorPos);
            --this.cursorPos;
            this.contents = String.valueOf(t1) + t2;
        }
        if (this.controller.parent.textWidth(this.contents) < (float)(this.getWidth() - 12)) {
            this.visiblePortionStart = 0;
            this.visiblePortionEnd = this.contents.length();
        } else if (this.cursorPos == this.contents.length()) {
            this.visiblePortionEnd = this.cursorPos;
            this.growLeft();
        } else if (this.cursorPos <= this.visiblePortionStart) {
            this.centerCursor();
        } else {
            this.visiblePortionEnd = this.visiblePortionStart;
            this.growRight();
        }
        this.fireEventNotification(this, "Modified");
    }

    private void deleteChar() {
        if (this.cursorPos >= this.contents.length()) {
            return;
        }
        ++this.cursorPos;
        this.backspaceChar();
    }

    private void updateXPos() {
        this.cursorXPos = this.controller.parent.textWidth(this.contents.substring(this.visiblePortionStart, this.cursorPos));
        if (this.startSelect != -1 && this.endSelect != -1) {
            int tempEnd;
            int tempStart;
            if (this.endSelect < this.startSelect) {
                tempStart = this.endSelect;
                tempEnd = this.startSelect;
            } else {
                tempStart = this.startSelect;
                tempEnd = this.endSelect;
            }
            this.startSelectXPos = tempStart < this.visiblePortionStart ? 0.0f : this.controller.parent.textWidth(this.contents.substring(this.visiblePortionStart, tempStart));
            this.endSelectXPos = tempEnd > this.visiblePortionEnd ? (float)(this.getWidth() - 4) : this.controller.parent.textWidth(this.contents.substring(this.visiblePortionStart, tempEnd));
        }
    }

    private void growRight() {
        while (this.controller.parent.textWidth(this.contents.substring(this.visiblePortionStart, this.visiblePortionEnd)) < (float)(this.getWidth() - 12)) {
            if (this.visiblePortionEnd == this.contents.length()) {
                if (this.visiblePortionStart == 0) break;
                --this.visiblePortionStart;
            }
            ++this.visiblePortionEnd;
        }
    }

    private void growLeft() {
        while (this.controller.parent.textWidth(this.contents.substring(this.visiblePortionStart, this.visiblePortionEnd)) < (float)(this.getWidth() - 12)) {
            if (this.visiblePortionStart == 0) {
                if (this.visiblePortionEnd == this.contents.length()) break;
                ++this.visiblePortionEnd;
            }
            --this.visiblePortionStart;
        }
    }

    private void shrinkRight() {
        while (this.controller.parent.textWidth(this.contents.substring(this.visiblePortionStart, this.visiblePortionEnd)) > (float)(this.getWidth() - 12)) {
            --this.visiblePortionEnd;
        }
    }

    private void shrinkLeft() {
        while (this.controller.parent.textWidth(this.contents.substring(this.visiblePortionStart, this.visiblePortionEnd)) > (float)(this.getWidth() - 12)) {
            ++this.visiblePortionStart;
        }
    }

    private void centerCursor() {
        this.visiblePortionStart = this.visiblePortionEnd = this.cursorPos;
        while (this.controller.parent.textWidth(this.contents.substring(this.visiblePortionStart, this.visiblePortionEnd)) < (float)(this.getWidth() - 12)) {
            if (this.visiblePortionStart != 0) {
                --this.visiblePortionStart;
            }
            if (this.visiblePortionEnd != this.contents.length()) {
                ++this.visiblePortionEnd;
            }
            if (this.visiblePortionEnd == this.contents.length() && this.visiblePortionStart == 0) break;
        }
    }

    private int findClosestGap(int x) {
        float prev = 0.0f;
        if (x < 0) {
            return this.visiblePortionStart;
        }
        if (x > this.getWidth()) {
            return this.visiblePortionEnd;
        }
        int i = this.visiblePortionStart;
        while (i < this.visiblePortionEnd) {
            float cur = this.controller.parent.textWidth(this.contents.substring(this.visiblePortionStart, i));
            if (cur > (float)x) {
                if (cur - (float)x < (float)x - prev) {
                    return i;
                }
                return i - 1;
            }
            prev = cur;
            ++i;
        }
        return this.contents.length();
    }

    public void setValue(String newValue) {
        this.contents = newValue;
        this.cursorPos = this.contents.length();
        this.endSelect = -1;
        this.startSelect = -1;
        this.visiblePortionStart = 0;
        this.visiblePortionEnd = this.contents.length();
        if (this.controller != null && this.controller.parent.textWidth(this.contents) > (float)(this.getWidth() - 12)) {
            this.shrinkRight();
        }
        this.fireEventNotification(this, "Set");
    }

    public String getValue() {
        return this.contents;
    }

    public void mouseEvent(MouseEvent e) {
        this.controller.userState.saveSettingsForApplet(this.controller.parent);
        this.lookAndFeel.defaultGraphicsState.restoreSettingsToApplet(this.controller.parent);
        if (e.getID() == 501) {
            if (this.isMouseOver(e.getX(), e.getY())) {
                this.controller.requestFocus(this);
                this.wasClicked = true;
                this.endSelect = -1;
                this.startSelect = this.cursorPos = this.findClosestGap(e.getX() - this.getX());
            } else if (this.controller.getFocusStatusForComponent(this)) {
                this.wasClicked = false;
                this.controller.yieldFocus(this);
                this.endSelect = -1;
                this.startSelect = -1;
            }
        } else if (e.getID() == 506) {
            this.endSelect = this.cursorPos = this.findClosestGap(e.getX() - this.getX());
        } else if (e.getID() == 502 && this.endSelect == this.startSelect) {
            this.startSelect = -1;
            this.endSelect = -1;
        }
        this.updateXPos();
        this.controller.userState.restoreSettingsToApplet(this.controller.parent);
    }

    public void keyEvent(KeyEvent e) {
        boolean shiftDown;
        this.controller.userState.saveSettingsForApplet(this.controller.parent);
        this.lookAndFeel.defaultGraphicsState.restoreSettingsToApplet(this.controller.parent);
        int shortcutMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        boolean bl = shiftDown = (e.getModifiersEx() & 0x40) == 64;
        if (e.getID() == 401) {
            if (e.getKeyCode() == 40) {
                if (shiftDown) {
                    if (this.startSelect == -1) {
                        this.startSelect = this.cursorPos;
                    }
                    this.cursorPos = this.visiblePortionEnd = this.contents.length();
                    this.endSelect = this.visiblePortionEnd;
                } else {
                    this.endSelect = -1;
                    this.startSelect = -1;
                    this.cursorPos = this.visiblePortionEnd = this.contents.length();
                }
                this.visiblePortionStart = this.visiblePortionEnd;
                this.growLeft();
            } else if (e.getKeyCode() == 38) {
                if (shiftDown) {
                    if (this.endSelect == -1) {
                        this.endSelect = this.cursorPos;
                    }
                    this.visiblePortionStart = 0;
                    this.cursorPos = 0;
                    this.startSelect = 0;
                } else {
                    this.endSelect = -1;
                    this.startSelect = -1;
                    this.visiblePortionStart = 0;
                    this.cursorPos = 0;
                }
                this.visiblePortionEnd = this.visiblePortionStart;
                this.growRight();
            } else if (e.getKeyCode() == 37) {
                if (shiftDown) {
                    if (this.cursorPos > 0) {
                        if (this.startSelect != -1 && this.endSelect != -1) {
                            --this.startSelect;
                            --this.cursorPos;
                        } else {
                            this.endSelect = this.cursorPos--;
                            this.startSelect = this.cursorPos;
                        }
                    }
                } else if (this.startSelect != -1 && this.endSelect != -1) {
                    this.cursorPos = Math.min(this.startSelect, this.endSelect);
                    this.endSelect = -1;
                    this.startSelect = -1;
                } else if (this.cursorPos > 0) {
                    --this.cursorPos;
                }
                this.centerCursor();
            } else if (e.getKeyCode() == 39) {
                if (shiftDown) {
                    if (this.cursorPos < this.contents.length()) {
                        if (this.startSelect != -1 && this.endSelect != -1) {
                            ++this.endSelect;
                            ++this.cursorPos;
                        } else {
                            this.startSelect = this.cursorPos++;
                            this.endSelect = this.cursorPos;
                        }
                    }
                } else if (this.startSelect != -1 && this.endSelect != -1) {
                    this.cursorPos = Math.max(this.startSelect, this.endSelect);
                    this.endSelect = -1;
                    this.startSelect = -1;
                } else if (this.cursorPos < this.contents.length()) {
                    ++this.cursorPos;
                }
                this.centerCursor();
            } else if (e.getKeyCode() == 127) {
                this.deleteChar();
            } else if (e.getKeyCode() == 10) {
                this.fireEventNotification(this, "Completed");
            } else if ((e.getModifiers() & shortcutMask) == shortcutMask) {
                switch (e.getKeyCode()) {
                    case 67: {
                        System.out.println("Copy");
                        break;
                    }
                    case 86: {
                        System.out.println("Paste");
                        break;
                    }
                    case 88: {
                        System.out.println("Cut");
                        break;
                    }
                    case 65: {
                        this.startSelect = 0;
                        this.endSelect = this.contents.length();
                    }
                    default: {
                        break;
                    }
                }
            }
        } else if (e.getID() == 400 && (e.getModifiers() & shortcutMask) != shortcutMask) {
            if (e.getKeyChar() == '\b') {
                this.backspaceChar();
            } else if (e.getKeyChar() != '\uffff' && IFTextField.validUnicode(e.getKeyChar())) {
                this.addChar(e.getKeyChar());
            }
        }
        this.updateXPos();
        this.controller.userState.restoreSettingsToApplet(this.controller.parent);
    }

    public void draw() {
        boolean hasFocus = this.controller.getFocusStatusForComponent(this);
        this.currentColor = this.wasClicked ? this.lookAndFeel.activeColor : (this.isMouseOver(this.controller.parent.mouseX, this.controller.parent.mouseY) || hasFocus ? this.lookAndFeel.highlightColor : this.lookAndFeel.baseColor);
        this.controller.parent.stroke(this.lookAndFeel.highlightColor);
        this.controller.parent.fill(this.lookAndFeel.borderColor);
        this.controller.parent.rect(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        this.controller.parent.noStroke();
        float offset = this.cursorPos == this.contents.length() && this.controller.parent.textWidth(this.contents) > (float)(this.getWidth() - 8) ? (float)(this.getWidth() - 4) - this.controller.parent.textWidth(this.contents.substring(this.visiblePortionStart, this.visiblePortionEnd)) : 4.0f;
        if (hasFocus && this.startSelect != -1 && this.endSelect != -1) {
            this.controller.parent.fill(this.lookAndFeel.selectionColor);
            this.controller.parent.rect((float)this.getX() + this.startSelectXPos + offset, this.getY() + 3, this.endSelectXPos - this.startSelectXPos + 1.0f, 15.0f);
        }
        this.controller.parent.fill(this.lookAndFeel.textColor);
        this.controller.parent.text(this.contents.substring(this.visiblePortionStart, this.visiblePortionEnd), (float)this.getX() + offset, (float)(this.getY() + 5), (float)(this.getWidth() - 8), (float)(this.getHeight() - 6));
        if (hasFocus && (this.startSelect == -1 || this.endSelect == -1) && this.controller.parent.millis() % 1000 > 500) {
            this.controller.parent.stroke(this.lookAndFeel.darkGrayColor);
            this.controller.parent.line((float)(this.getX() + (int)this.cursorXPos) + offset, this.getY() + 3, (float)(this.getX() + (int)this.cursorXPos) + offset, this.getY() + 18);
        }
    }

    public void actionPerformed(GUIEvent e) {
        super.actionPerformed(e);
        if (e.getSource() == this) {
            if (e.getMessage().equals("Received Focus")) {
                if (this.contents != "") {
                    this.startSelect = 0;
                    this.endSelect = this.contents.length();
                }
            } else if (e.getMessage().equals("Lost Focus") && this.contents != "") {
                this.endSelect = -1;
                this.startSelect = -1;
            }
        }
    }
}

