/*
 * Decompiled with CFR 0.152.
 */
package interfascia;

import interfascia.GUIComponent;
import interfascia.IFRadioController;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class IFRadioButton
extends GUIComponent {
    private int currentColor;
    private boolean selected;
    private IFRadioController radioController;

    public IFRadioButton(String newLabel, int newX, int newY, IFRadioController newController) {
        this.setLabel(newLabel);
        this.setPosition(newX, newY + 1);
        this.setSize(15, 15);
        this.radioController = newController;
        this.radioController.add(this);
    }

    public void initWithParent() {
        this.controller.parent.registerMouseEvent(this);
        if (this.lookAndFeel == null) {
            return;
        }
        this.controller.userState.saveSettingsForApplet(this.controller.parent);
        this.lookAndFeel.defaultGraphicsState.restoreSettingsToApplet(this.controller.parent);
        this.setSize((int)Math.ceil(this.controller.parent.textWidth(this.getLabel())) + this.getHeight() + 5, 14);
        this.controller.userState.restoreSettingsToApplet(this.controller.parent);
    }

    public void mouseEvent(MouseEvent e) {
        if (e.getID() == 501) {
            if (this.isMouseOver(e.getX(), e.getY())) {
                this.wasClicked = true;
            }
        } else if (e.getID() == 502 && this.wasClicked && this.isMouseOver(e.getX(), e.getY())) {
            this.radioController.selectButton(this);
            this.wasClicked = false;
        }
    }

    public void keyEvent(KeyEvent e) {
        if (e.getID() == 400 && e.getKeyChar() == ' ') {
            this.radioController.selectButton(this);
        }
    }

    public void draw() {
        this.currentColor = this.isMouseOver(this.controller.parent.mouseX, this.controller.parent.mouseY) ? this.lookAndFeel.highlightColor : (this.controller.getFocusStatusForComponent(this) ? this.lookAndFeel.highlightColor : this.lookAndFeel.baseColor);
        int x = this.getX();
        int y = this.getY();
        int hgt = this.getHeight();
        int wid = this.getWidth();
        this.controller.parent.stroke(this.lookAndFeel.borderColor);
        this.controller.parent.fill(this.currentColor);
        this.controller.parent.ellipse(x, y, hgt, hgt);
        if (this.radioController.getSelectionStatusForButton(this)) {
            this.controller.parent.fill(this.lookAndFeel.lightGrayColor);
            this.controller.parent.ellipse(x + 2, y + 2, hgt - 4, hgt - 4);
        }
        this.controller.parent.fill(this.lookAndFeel.textColor);
        this.controller.parent.text(this.getLabel(), (float)(hgt + x + 5), (float)(hgt - 3 + y));
        if (this.controller.showBounds) {
            this.controller.parent.noFill();
            this.controller.parent.stroke(255.0f, 0.0f, 0.0f);
            this.controller.parent.rect(x, y, wid, hgt);
        }
    }

    public boolean isSelected() {
        return this.radioController.getSelectionStatusForButton(this);
    }

    public void setSelected() {
        this.radioController.selectButton(this);
    }
}

