% MAKESDP   creates a random SDP problem with a solution having
%           prescribed ranks
%
%   The optimal point is saved in (Xsolorig,ysolorig,Zsolorig) and
%   the optimal objective value in objsolorig.
%
% The following variables must be available in the Matlab workspace:
%    - blk      size of problem  (no block diagonal structure)
%    - m        number of constraints
%    - r        rank of Xsol
%    - s        rank of Zsol
%
%   Of course we must have r+s <= n
%   Recall that:
%     sc  <==>  r + s = n
%     pn   ==>  m <= n(n+1)/2  - (n-r)(n-r+1)/2
%     dn   ==>  m >= (n-s)(n-s+1)/2

% SDPPACK Version 0.8 BETA
% Copyright (c) 1997 by
% F. Alizadeh, J.-P. Haeberly, M. Nayakkankuppam, M.L. Overton
% Last modified: 3/24/97
%
 if (exist('r') ~= 1) | (exist('s') ~= 1),
    error('\n makesdp: r and/or s not defined!\n');
 end;
 if exist('blk') ~= 1,
    error('\n makesdp: block structure blk not defined!\n');
 end;
 if length(blk) > 1,
    error('\n makesdp: no block diagonal problems allowed!\n');
 else
    n = blk;
 end;
 if exist('m') ~= 1,
    error('\n makesdp: number of constraints m not defined!\n');
 end;
 if (r + s > n),
    error('\n makesdp: r + s > n!')
 end;
 if (r + s < n),
    fprintf('\n makesdp: strict complementarity violated\n');
 end;
 if m > (n*(n+1) - (n-r)*(n-r+1))/2 ,
    fprintf('\n makesdp: primal nondegeneracy violated\n');
 end;
 if m < (n-s)*(n-s+1)/2,
    fprintf('\n makesdp: dual nondegeneracy violated\n');
 end;
%
 Xsolorig = zeros(n);
 Zsolorig = zeros(n);
 Xsolorig(1:r,1:r) = randpos(r);
 tmp  = randsym(s);
 Zsolorig(n-s+1:n,n-s+1:n) = randpos(s);
%
 n2 = n*(n+1)/2;
%
 A = zeros(m,n2);  % the rows of A hold the vector form of the
                   % matrices Ak, 1 <= k <= m
% set up the matrices Ak
%
 for i = 1:m,
    randmat = randsym(n);
    A(i,:) = svec(randmat,blk)';
 end;
%
 b = A*svec(Xsolorig,blk);              % so problem is primal feasible
 ysolorig = rand(m,1);
 C = smat(A'*ysolorig,blk) + Zsolorig;  % so problem is dual feasible
 objsolorig = trace(C*Xsolorig);        % optimal objective value
%
