/* file: Utilities.java
 *
 * From p.198, chap.9 (Images) of Knudsen
 * Key illustration:
 *	--how to convert from image to Buffered Image
 * How to use this Utilities class:
 *	--see the main method
 ************************************************************/
import java.awt.*;
import java.awt.event.*;
import java.awt.image.BufferedImage;
import java.net.URL;

public class Utilities {
  private static final Component sComponent = new Component() {};
  private static final MediaTracker sTracker = new
		MediaTracker(sComponent);
  private static int sID = 0;

  public static boolean waitForImage(Image image) {
    int id;
    synchronized (sComponent) { id = sID++; }
    sTracker.addImage(image, id);
    try { sTracker.waitForID(id); }
    catch (InterruptedException ie) { return false; }
    if (sTracker.isErrorID(id)) return false;
    return true;
  }// waitForImage

  public static Image blockingLoad(String path) {
    Image image = Toolkit.getDefaultToolkit().getImage(path);
    if (waitForImage(image) == false) return null;
    return image;
  }//blockingLoad

  public static Image blockingLoad(URL url) {
    Image image = Toolkit.getDefaultToolkit().getImage(url);
    if (waitForImage(image) == false) return null;
    return image;
  }//blockingLoad

  public static BufferedImage makeBufferedImage(Image image) {
    return makeBufferedImage(image, BufferedImage.TYPE_INT_RGB);
  }//makeBufferedImage

  /* 
  The key method -- how to transfer an Image to a BufferedImage
  */
  public static BufferedImage makeBufferedImage(Image image,
	int imageType) {

    // load image
    if (waitForImage(image) == false) return null;
    // construct BufferedImage
    BufferedImage bufferedImage = new BufferedImage(
	image.getWidth(null), image.getHeight(null),
	imageType);
    // construct Graphics2D from BufferedImage
    Graphics2D g2 = bufferedImage.createGraphics();
    // draw image on Graphics2D 
    g2.drawImage (image, null, null);
    return bufferedImage;

  }//makeBufferedImage

  public static Frame getNonClearingFrame(String name, Component c) {
    final Frame f = new Frame(name) {
	public void update(Graphics g) {paint(g); }
    };// new Frame
    sizeContainerToComponent(f, c);
    centerFrame(f);
    f.setLayout(new BorderLayout());
    f.add(c, BorderLayout.CENTER);
    f.addWindowListener(new WindowAdapter() {
	public void windowClosing(WindowEvent e) {f.dispose();}
    } );
    return f;
  }//getNonClearingFrame

  public static void sizeContainerToComponent(Container con,
	Component com) {
    if (con.isDisplayable() == false) con.addNotify();
    Insets insets = con.getInsets();
    Dimension size = com.getPreferredSize();
    int width = insets.left + insets.right + size.width;
    int height = insets.top + insets.bottom + size.height;
    con.setSize(width, height);
  }//sizeContainerToComponent

  public static void centerFrame(Frame f) {
    Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
    Dimension d = f.getSize();
    int x = (screen.width -d.width) /2;
    int y = (screen.height -d.height) /2;
    f.setLocation(x, y);
  }//centerFrame

  public static void main(String[] args) {
    
    // get image 
    System.out.println("Start");
    Image im = blockingLoad("/home/yap/data/images/gifIcon.gif");

    String s = "got it!";
    if (im == null) s = "nop!";
    System.out.println(s);

    // get frame
    Frame f = getNonClearingFrame("Utilities Frame", Component c) {

    System.out.println("Stop");
  }//main

}//class Utilities
